/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.tree.BinaryExpressionTree;
import org.sonar.plugins.java.api.tree.ConditionalExpressionTree;
import org.sonar.plugins.java.api.tree.LiteralTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.UnaryExpressionTree;

@Rule(key="S1125")
public class BooleanLiteralCheck
extends IssuableSubscriptionVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.EQUAL_TO, (Object)Tree.Kind.NOT_EQUAL_TO, (Object)Tree.Kind.CONDITIONAL_AND, (Object)Tree.Kind.CONDITIONAL_OR, (Object)Tree.Kind.LOGICAL_COMPLEMENT, (Object)Tree.Kind.CONDITIONAL_EXPRESSION);
    }

    public void visitNode(Tree tree) {
        LiteralTree literal;
        if (tree.is(new Tree.Kind[]{Tree.Kind.LOGICAL_COMPLEMENT})) {
            literal = BooleanLiteralCheck.getBooleanLiteral(new Tree[]{((UnaryExpressionTree)tree).expression()});
        } else if (tree.is(new Tree.Kind[]{Tree.Kind.CONDITIONAL_EXPRESSION})) {
            ConditionalExpressionTree expression = (ConditionalExpressionTree)tree;
            literal = BooleanLiteralCheck.getBooleanLiteral(new Tree[]{expression.trueExpression(), expression.falseExpression()});
        } else {
            BinaryExpressionTree expression = (BinaryExpressionTree)tree;
            literal = BooleanLiteralCheck.getBooleanLiteral(new Tree[]{expression.leftOperand(), expression.rightOperand()});
        }
        if (literal != null) {
            this.reportIssue((Tree)literal, "Remove the literal \"" + literal.value() + "\" boolean value.");
        }
    }

    @Nullable
    private static LiteralTree getBooleanLiteral(Tree ... trees) {
        return Arrays.stream(trees).filter(tree -> tree.is(new Tree.Kind[]{Tree.Kind.BOOLEAN_LITERAL})).map(LiteralTree.class::cast).findFirst().orElse(null);
    }
}

