/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.tree.CatchTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TypeTree;
import org.sonar.plugins.java.api.tree.UnionTypeTree;

@Rule(key="S2235")
public class CatchIllegalMonitorStateExceptionCheck
extends IssuableSubscriptionVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.CATCH);
    }

    public void visitNode(Tree tree) {
        CatchTree catchTree = (CatchTree)tree;
        TypeTree parameterTypeTree = catchTree.parameter().type();
        if (parameterTypeTree.is(new Tree.Kind[]{Tree.Kind.UNION_TYPE})) {
            UnionTypeTree unionTypeTree = (UnionTypeTree)parameterTypeTree;
            for (TypeTree exceptionTypeTree : unionTypeTree.typeAlternatives()) {
                this.checkExceptionType(exceptionTypeTree);
            }
        } else {
            this.checkExceptionType(parameterTypeTree);
        }
    }

    private void checkExceptionType(TypeTree exceptionTypeTree) {
        if (exceptionTypeTree.symbolType().is("java.lang.IllegalMonitorStateException")) {
            this.reportIssue((Tree)exceptionTypeTree, "Refactor this piece of code to not catch IllegalMonitorStateException");
        }
    }
}

