/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.java.matcher.MethodMatcher;
import org.sonar.java.matcher.MethodMatcherCollection;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;

@Rule(key="S1872")
public class ClassComparedByNameCheck
extends AbstractMethodDetection {
    @Override
    protected List<MethodMatcher> getMethodInvocationMatchers() {
        return ImmutableList.of((Object)MethodMatcher.create().typeDefinition("java.lang.String").name("equals").withAnyParameters());
    }

    @Override
    protected void onMethodInvocationFound(MethodInvocationTree mit) {
        if (!mit.methodSelect().is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
            return;
        }
        ExpressionTree firstOperand = ExpressionUtils.skipParentheses((ExpressionTree)((MemberSelectExpressionTree)mit.methodSelect()).expression());
        ExpressionTree secondOperand = ExpressionUtils.skipParentheses((ExpressionTree)((ExpressionTree)mit.arguments().get(0)));
        boolean firstOpIsClassGetNameMethod = ClassComparedByNameCheck.useClassGetNameMethod(firstOperand);
        boolean secondOpIsClassGetNameMethod = ClassComparedByNameCheck.useClassGetNameMethod(secondOperand);
        if (firstOpIsClassGetNameMethod && secondOpIsClassGetNameMethod) {
            this.reportIssue((Tree)mit, "Use \"isAssignableFrom\" instead.");
        } else if (firstOpIsClassGetNameMethod && secondOperand.is(new Tree.Kind[]{Tree.Kind.STRING_LITERAL}) || secondOpIsClassGetNameMethod && firstOperand.is(new Tree.Kind[]{Tree.Kind.STRING_LITERAL})) {
            this.reportIssue((Tree)mit, "Use an \"instanceof\" comparison instead.");
        }
    }

    private static boolean useClassGetNameMethod(ExpressionTree expression) {
        ClassGetNameDetector visitor = new ClassGetNameDetector();
        expression.accept((TreeVisitor)visitor);
        return visitor.useClassGetName;
    }

    private static class ClassGetNameDetector
    extends BaseTreeVisitor {
        private boolean useClassGetName = false;
        private static final MethodMatcherCollection METHOD_MATCHERS = MethodMatcherCollection.create((MethodMatcher[])new MethodMatcher[]{MethodMatcher.create().typeDefinition("java.lang.Class").name("getName").withoutParameter(), MethodMatcher.create().typeDefinition("java.lang.Class").name("getSimpleName").withoutParameter()});

        private ClassGetNameDetector() {
        }

        public void visitMethodInvocation(MethodInvocationTree tree) {
            if (METHOD_MATCHERS.anyMatch(tree)) {
                this.useClassGetName = true;
            }
            this.scan((Tree)tree.methodSelect());
        }
    }
}

