/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.text.MessageFormat;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.java.matcher.MethodMatcher;
import org.sonar.java.matcher.TypeCriteria;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.java.resolve.JavaSymbol;
import org.sonar.java.resolve.JavaType;
import org.sonar.java.resolve.ParametrizedTypeJavaType;
import org.sonar.java.resolve.TypeVariableJavaType;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S2175")
public class CollectionInappropriateCallsCheck
extends AbstractMethodDetection {
    @Override
    protected List<MethodMatcher> getMethodInvocationMatchers() {
        return ImmutableList.of((Object)CollectionInappropriateCallsCheck.collectionMethodInvocation("remove"), (Object)CollectionInappropriateCallsCheck.collectionMethodInvocation("contains"));
    }

    private static MethodMatcher collectionMethodInvocation(String methodName) {
        return MethodMatcher.create().typeDefinition(TypeCriteria.subtypeOf((String)"java.util.Collection")).name(methodName).addParameter("java.lang.Object");
    }

    @Override
    protected void onMethodInvocationFound(MethodInvocationTree tree) {
        ExpressionTree firstArgument = (ExpressionTree)tree.arguments().get(0);
        Type argumentType = firstArgument.symbolType();
        if (argumentType.isUnknown()) {
            return;
        }
        Type collectionType = CollectionInappropriateCallsCheck.getMethodOwner(tree);
        Type collectionParameterType = CollectionInappropriateCallsCheck.getTypeParameter(collectionType);
        boolean isCallToParametrizedOrUnknownMethod = CollectionInappropriateCallsCheck.isCallToParametrizedOrUnknownMethod(firstArgument);
        if (!isCallToParametrizedOrUnknownMethod && tree.methodSelect().is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
            isCallToParametrizedOrUnknownMethod = CollectionInappropriateCallsCheck.isCallToParametrizedOrUnknownMethod(((MemberSelectExpressionTree)tree.methodSelect()).expression());
        }
        if (!(collectionParameterType == null || collectionParameterType.isUnknown() || isCallToParametrizedOrUnknownMethod || CollectionInappropriateCallsCheck.isArgumentCompatible(argumentType, collectionParameterType))) {
            this.reportIssue((Tree)ExpressionUtils.methodName((MethodInvocationTree)tree), MessageFormat.format("A \"{0}<{1}>\" cannot contain a \"{2}\"", collectionType, collectionParameterType, argumentType));
        }
    }

    private static boolean isCallToParametrizedOrUnknownMethod(ExpressionTree expressionTree) {
        if (expressionTree.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION})) {
            Symbol symbol = ((MethodInvocationTree)expressionTree).symbol();
            return symbol.isUnknown() || ((JavaSymbol.MethodJavaSymbol)symbol).isParametrized();
        }
        return false;
    }

    private static Type getMethodOwner(MethodInvocationTree mit) {
        if (mit.methodSelect().is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
            return ((MemberSelectExpressionTree)mit.methodSelect()).expression().symbolType();
        }
        return mit.symbol().owner().type();
    }

    @Nullable
    private static Type getTypeParameter(Type collectionType) {
        if (collectionType.is("java.util.Collection") && collectionType instanceof ParametrizedTypeJavaType) {
            ParametrizedTypeJavaType parametrizedType = (ParametrizedTypeJavaType)collectionType;
            TypeVariableJavaType first = (TypeVariableJavaType)Iterables.getFirst((Iterable)parametrizedType.typeParameters(), null);
            if (first != null) {
                return parametrizedType.substitution(first);
            }
        } else if (collectionType instanceof ParametrizedTypeJavaType) {
            return ((JavaType)collectionType).directSuperTypes().stream().map(CollectionInappropriateCallsCheck::getTypeParameter).filter(Objects::nonNull).findFirst().orElse(null);
        }
        return null;
    }

    private static boolean isArgumentCompatible(Type argumentType, Type collectionParameterType) {
        return CollectionInappropriateCallsCheck.isSubtypeOf(argumentType, collectionParameterType) || CollectionInappropriateCallsCheck.isSubtypeOf(collectionParameterType, argumentType) || CollectionInappropriateCallsCheck.autoboxing(argumentType, collectionParameterType);
    }

    private static boolean isSubtypeOf(Type type, Type superType) {
        return type.isSubtypeOf(superType);
    }

    private static boolean autoboxing(Type argumentType, Type collectionParameterType) {
        return argumentType.isPrimitive() && ((JavaType)collectionParameterType).isPrimitiveWrapper() && CollectionInappropriateCallsCheck.isSubtypeOf((Type)((JavaType)argumentType).primitiveWrapperType(), collectionParameterType);
    }
}

