/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.checks.helpers.ExpressionsHelper;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S2257")
public class CustomCryptographicAlgorithmCheck
extends IssuableSubscriptionVisitor {
    private static final String MESSAGE_DIGEST_QUALIFIED_NAME = "java.security.MessageDigest";
    private static final String MESSAGE = "Make sure using a non-standard cryptographic algorithm is safe here.";

    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.CLASS);
    }

    public void visitNode(Tree tree) {
        ClassTree classTree = (ClassTree)tree;
        if (this.hasSemantic() && CustomCryptographicAlgorithmCheck.isJavaSecurityMessageDigestSubClass(classTree)) {
            this.reportIssue(ExpressionsHelper.reportOnClassTree(classTree), MESSAGE);
        }
    }

    private static boolean isJavaSecurityMessageDigestSubClass(ClassTree tree) {
        Symbol.TypeSymbol classSymbol = tree.symbol();
        return classSymbol != null && !classSymbol.type().is(MESSAGE_DIGEST_QUALIFIED_NAME) && classSymbol.type().isSubtypeOf(MESSAGE_DIGEST_QUALIFIED_NAME);
    }
}

