/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.sonar.check.Rule;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.java.matcher.MethodMatcher;
import org.sonar.java.matcher.MethodMatcherCollection;
import org.sonar.java.matcher.TypeCriteria;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.Arguments;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TypeCastTree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S1943")
public class DefaultEncodingUsageCheck
extends AbstractMethodDetection {
    private static final String INT = "int";
    private static final String BOOLEAN = "boolean";
    private static final String BYTE_ARRAY = "byte[]";
    private static final String JAVA_IO_FILE = "java.io.File";
    private static final String JAVA_IO_READER = "java.io.Reader";
    private static final String JAVA_IO_WRITER = "java.io.Writer";
    private static final String JAVA_IO_FILEWRITER = "java.io.FileWriter";
    private static final String JAVA_IO_FILEREADER = "java.io.FileReader";
    private static final String JAVA_IO_PRINTWRITER = "java.io.PrintWriter";
    private static final String JAVA_IO_PRINTSTREAM = "java.io.PrintStream";
    private static final String JAVA_IO_INPUTSTREAM = "java.io.InputStream";
    private static final String JAVA_IO_OUTPUTSTREAM = "java.io.OutputStream";
    private static final String JAVA_IO_BYTEARRAYOUTPUTSTREAM = "java.io.ByteArrayOutputStream";
    private static final String JAVA_IO_OUTPUTSTREAMWRITER = "java.io.OutputStreamWriter";
    private static final String JAVA_IO_INPUTSTREAMREADER = "java.io.InputStreamReader";
    private static final String JAVA_NIO_FILE_PATH = "java.nio.file.Path";
    private static final String JAVA_NIO_CHARSET = "java.nio.charset.Charset";
    private static final String JAVA_LANG_CHARSEQUENCE = "java.lang.CharSequence";
    private static final String JAVA_LANG_STRING = "java.lang.String";
    private static final String JAVA_UTIL_SCANNER = "java.util.Scanner";
    private static final String JAVA_UTIL_FORMATTER = "java.util.Formatter";
    private static final String[] FORBIDDEN_TYPES = new String[]{"java.io.FileReader", "java.io.FileWriter"};
    private static final String COMMONS_IOUTILS = "org.apache.commons.io.IOUtils";
    private static final String COMMONS_FILEUTILS = "org.apache.commons.io.FileUtils";
    private static final List<MethodMatcher> COMMONS_IO = ImmutableList.of((Object)DefaultEncodingUsageCheck.method("org.apache.commons.io.IOUtils", "copy").parameters(new String[]{"java.io.InputStream", "java.io.Writer"}), (Object)DefaultEncodingUsageCheck.method("org.apache.commons.io.IOUtils", "copy").parameters(new String[]{"java.io.Reader", "java.io.OutputStream"}), (Object)DefaultEncodingUsageCheck.method("org.apache.commons.io.IOUtils", "readLines").parameters(new String[]{"java.io.InputStream"}), (Object)DefaultEncodingUsageCheck.method("org.apache.commons.io.IOUtils", "toByteArray").parameters(new String[]{"java.io.Reader"}), (Object)DefaultEncodingUsageCheck.method("org.apache.commons.io.IOUtils", "toCharArray").parameters(new String[]{"java.io.InputStream"}), (Object)DefaultEncodingUsageCheck.method("org.apache.commons.io.IOUtils", "toInputStream").parameters(new String[]{"java.lang.CharSequence"}), (Object)DefaultEncodingUsageCheck.method("org.apache.commons.io.IOUtils", "toInputStream").parameters(new String[]{"java.lang.String"}), (Object)DefaultEncodingUsageCheck.method("org.apache.commons.io.IOUtils", "toString").parameters(new String[]{"byte[]"}), (Object)DefaultEncodingUsageCheck.method("org.apache.commons.io.IOUtils", "toString").parameters(new String[]{"java.net.URI"}), (Object)DefaultEncodingUsageCheck.method("org.apache.commons.io.IOUtils", "toString").parameters(new String[]{"java.net.URL"}), (Object)DefaultEncodingUsageCheck.method("org.apache.commons.io.IOUtils", "write").parameters(new String[]{"char[]", "java.io.OutputStream"}), (Object)DefaultEncodingUsageCheck.method("org.apache.commons.io.IOUtils", "write").parameters(new TypeCriteria[]{TypeCriteria.subtypeOf((String)"java.lang.CharSequence"), TypeCriteria.is((String)"java.io.OutputStream")}), (Object[])new MethodMatcher[]{DefaultEncodingUsageCheck.method("org.apache.commons.io.IOUtils", "writeLines").parameters(new String[]{"java.util.Collection", "java.lang.String", "java.io.OutputStream"}), DefaultEncodingUsageCheck.method("org.apache.commons.io.FileUtils", "readFileToString").parameters(new String[]{"java.io.File"}), DefaultEncodingUsageCheck.method("org.apache.commons.io.FileUtils", "readLines").parameters(new String[]{"java.io.File"}), DefaultEncodingUsageCheck.method("org.apache.commons.io.FileUtils", "write").parameters(new String[]{"java.io.File", "java.lang.CharSequence"}), DefaultEncodingUsageCheck.method("org.apache.commons.io.FileUtils", "write").parameters(new String[]{"java.io.File", "java.lang.CharSequence", "boolean"}), DefaultEncodingUsageCheck.method("org.apache.commons.io.FileUtils", "writeStringToFile").parameters(new String[]{"java.io.File", "java.lang.String"})});
    private static final List<MethodMatcher> COMMONS_IO_WITH_CHARSET = COMMONS_IO.stream().flatMap(m -> Stream.of(m.copy().addParameter(JAVA_LANG_STRING), m.copy().addParameter(JAVA_NIO_CHARSET))).collect(Collectors.toList());
    private static final MethodMatcherCollection COMMONS_IO_CHARSET_MATCHERS = MethodMatcherCollection.create((MethodMatcher[])COMMONS_IO_WITH_CHARSET.toArray(new MethodMatcher[0]));
    private static final List<MethodMatcher> FILEUTILS_WRITE_WITH_CHARSET = ImmutableList.of((Object)DefaultEncodingUsageCheck.method("org.apache.commons.io.FileUtils", "write").parameters(new String[]{"java.io.File", "java.lang.CharSequence", "java.lang.String", "boolean"}), (Object)DefaultEncodingUsageCheck.method("org.apache.commons.io.FileUtils", "write").parameters(new String[]{"java.io.File", "java.lang.CharSequence", "java.nio.charset.Charset", "boolean"}));
    private static final MethodMatcherCollection FILEUTILS_WRITE_WITH_CHARSET_MATCHERS = MethodMatcherCollection.create((MethodMatcher[])FILEUTILS_WRITE_WITH_CHARSET.toArray(new MethodMatcher[0]));
    private Set<Tree> excluded = Sets.newHashSet();

    public void scanFile(JavaFileScannerContext context) {
        super.scanFile(context);
        this.excluded.clear();
    }

    @Override
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.METHOD_INVOCATION, (Object)Tree.Kind.NEW_CLASS, (Object)Tree.Kind.VARIABLE);
    }

    @Override
    public void visitNode(Tree tree) {
        if (!this.excluded.contains(tree)) {
            super.visitNode(tree);
            if (tree.is(new Tree.Kind[]{Tree.Kind.VARIABLE})) {
                VariableTree variableTree = (VariableTree)tree;
                boolean foundIssue = this.checkForbiddenTypes((Tree)variableTree.simpleName(), variableTree.type().symbolType());
                if (foundIssue) {
                    this.excluded.add((Tree)variableTree.initializer());
                }
            } else if (tree.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION})) {
                MethodInvocationTree mit = (MethodInvocationTree)tree;
                this.checkForbiddenTypes((Tree)ExpressionUtils.methodName((MethodInvocationTree)mit), mit.symbolType());
            }
        }
    }

    private boolean checkForbiddenTypes(Tree reportTree, Type symbolType) {
        for (String forbiddenType : FORBIDDEN_TYPES) {
            if (!symbolType.is(forbiddenType)) continue;
            this.reportIssue(reportTree, "Remove this use of \"" + forbiddenType + "\"");
            return true;
        }
        return false;
    }

    @Override
    protected List<MethodMatcher> getMethodInvocationMatchers() {
        ImmutableList.Builder matchers = ImmutableList.builder().add((Object[])new MethodMatcher[]{DefaultEncodingUsageCheck.method(JAVA_LANG_STRING, "getBytes").withoutParameter(), DefaultEncodingUsageCheck.method(JAVA_LANG_STRING, "getBytes").parameters(new String[]{INT, INT, BYTE_ARRAY, INT}), DefaultEncodingUsageCheck.constructor(JAVA_LANG_STRING).parameters(new String[]{BYTE_ARRAY}), DefaultEncodingUsageCheck.constructor(JAVA_LANG_STRING).parameters(new String[]{BYTE_ARRAY, INT, INT}), DefaultEncodingUsageCheck.method(JAVA_IO_BYTEARRAYOUTPUTSTREAM, "toString").withoutParameter(), DefaultEncodingUsageCheck.constructor(JAVA_IO_FILEREADER).withAnyParameters(), DefaultEncodingUsageCheck.constructor(JAVA_IO_FILEWRITER).withAnyParameters(), DefaultEncodingUsageCheck.constructor(JAVA_IO_INPUTSTREAMREADER).parameters(new String[]{JAVA_IO_INPUTSTREAM}), DefaultEncodingUsageCheck.constructor(JAVA_IO_OUTPUTSTREAMWRITER).parameters(new String[]{JAVA_IO_OUTPUTSTREAM}), DefaultEncodingUsageCheck.constructor(JAVA_IO_PRINTSTREAM).parameters(new String[]{JAVA_IO_FILE}), DefaultEncodingUsageCheck.constructor(JAVA_IO_PRINTSTREAM).parameters(new String[]{JAVA_IO_OUTPUTSTREAM}), DefaultEncodingUsageCheck.constructor(JAVA_IO_PRINTSTREAM).parameters(new String[]{JAVA_IO_OUTPUTSTREAM, BOOLEAN}), DefaultEncodingUsageCheck.constructor(JAVA_IO_PRINTSTREAM).parameters(new String[]{JAVA_LANG_STRING}), DefaultEncodingUsageCheck.constructor(JAVA_IO_PRINTWRITER).parameters(new String[]{JAVA_IO_FILE}), DefaultEncodingUsageCheck.constructor(JAVA_IO_PRINTWRITER).parameters(new String[]{JAVA_IO_OUTPUTSTREAM}), DefaultEncodingUsageCheck.constructor(JAVA_IO_PRINTWRITER).parameters(new String[]{JAVA_IO_OUTPUTSTREAM, BOOLEAN}), DefaultEncodingUsageCheck.constructor(JAVA_IO_PRINTWRITER).parameters(new String[]{JAVA_LANG_STRING}), DefaultEncodingUsageCheck.constructor(JAVA_UTIL_FORMATTER).parameters(new String[]{JAVA_LANG_STRING}), DefaultEncodingUsageCheck.constructor(JAVA_UTIL_FORMATTER).parameters(new String[]{JAVA_IO_FILE}), DefaultEncodingUsageCheck.constructor(JAVA_UTIL_FORMATTER).parameters(new String[]{JAVA_IO_OUTPUTSTREAM}), DefaultEncodingUsageCheck.constructor(JAVA_UTIL_SCANNER).parameters(new String[]{JAVA_IO_FILE}), DefaultEncodingUsageCheck.constructor(JAVA_UTIL_SCANNER).parameters(new String[]{JAVA_NIO_FILE_PATH}), DefaultEncodingUsageCheck.constructor(JAVA_UTIL_SCANNER).parameters(new String[]{JAVA_IO_INPUTSTREAM})});
        matchers.addAll(COMMONS_IO);
        matchers.addAll(COMMONS_IO_WITH_CHARSET);
        matchers.addAll(FILEUTILS_WRITE_WITH_CHARSET);
        return matchers.build();
    }

    private static MethodMatcher method(String type, String methodName) {
        return MethodMatcher.create().typeDefinition(type).name(methodName);
    }

    private static MethodMatcher constructor(String type) {
        return DefaultEncodingUsageCheck.method(type, "<init>");
    }

    @Override
    protected void onMethodInvocationFound(MethodInvocationTree mit) {
        if (COMMONS_IO_CHARSET_MATCHERS.anyMatch(mit)) {
            Arguments arguments = mit.arguments();
            ExpressionTree lastArgument = (ExpressionTree)arguments.get(arguments.size() - 1);
            this.testNullLiteralPassedForEncoding(lastArgument);
        } else if (FILEUTILS_WRITE_WITH_CHARSET_MATCHERS.anyMatch(mit)) {
            this.testNullLiteralPassedForEncoding((ExpressionTree)mit.arguments().get(2));
        } else {
            this.reportIssue((Tree)ExpressionUtils.methodName((MethodInvocationTree)mit), "Remove this use of \"" + mit.symbol().name() + "\"");
        }
    }

    private void testNullLiteralPassedForEncoding(ExpressionTree argument) {
        if (DefaultEncodingUsageCheck.isNullLiteral(argument)) {
            this.reportIssue((Tree)argument, "Replace this \"null\" with actual charset.");
        }
    }

    private static boolean isNullLiteral(ExpressionTree lastArgument) {
        ExpressionTree arg = ExpressionUtils.skipParentheses((ExpressionTree)lastArgument);
        return arg.is(new Tree.Kind[]{Tree.Kind.NULL_LITERAL}) || arg.is(new Tree.Kind[]{Tree.Kind.TYPE_CAST}) && DefaultEncodingUsageCheck.isNullLiteral(((TypeCastTree)arg).expression());
    }

    @Override
    protected void onConstructorFound(NewClassTree newClassTree) {
        Symbol symbol = newClassTree.constructorSymbol();
        if (symbol.isMethodSymbol()) {
            Symbol.MethodSymbol constructor = (Symbol.MethodSymbol)symbol;
            String signature = constructor.owner().name() + "(" + Joiner.on((char)',').join((Iterable)constructor.parameterTypes()) + ")";
            this.reportIssue((Tree)newClassTree.identifier(), "Remove this use of constructor \"" + signature + "\"");
        }
    }
}

