/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import org.sonar.check.Rule;
import org.sonar.java.checks.helpers.JavaPropertiesHelper;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.java.matcher.MethodMatcher;
import org.sonar.java.matcher.TypeCriteria;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.java.model.LiteralUtils;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.LiteralTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S2070")
public class DeprecatedHashAlgorithmCheck
extends AbstractMethodDetection {
    private static final String JAVA_LANG_STRING = "java.lang.String";
    private static final String GET_INSTANCE = "getInstance";
    private static final String CONSTRUCTOR = "<init>";
    private static final List<String> CRYPTO_APIS = Arrays.asList("java.security.AlgorithmParameters", "java.security.AlgorithmParameterGenerator", "java.security.MessageDigest", "java.security.KeyFactory", "java.security.KeyPairGenerator", "java.security.Signature", "javax.crypto.Mac", "javax.crypto.KeyGenerator");
    private static final Map<String, InsecureAlgorithm> ALGORITHM_BY_METHOD_NAME = ImmutableMap.builder().put((Object)"getMd2Digest", (Object)InsecureAlgorithm.MD2).put((Object)"getMd5Digest", (Object)InsecureAlgorithm.MD5).put((Object)"getShaDigest", (Object)InsecureAlgorithm.SHA1).put((Object)"getSha1Digest", (Object)InsecureAlgorithm.SHA1).put((Object)"md2", (Object)InsecureAlgorithm.MD2).put((Object)"md2Hex", (Object)InsecureAlgorithm.MD2).put((Object)"md5", (Object)InsecureAlgorithm.MD5).put((Object)"md5Hex", (Object)InsecureAlgorithm.MD5).put((Object)"sha1", (Object)InsecureAlgorithm.SHA1).put((Object)"sha1Hex", (Object)InsecureAlgorithm.SHA1).put((Object)"sha", (Object)InsecureAlgorithm.SHA1).put((Object)"shaHex", (Object)InsecureAlgorithm.SHA1).build();

    @Override
    protected List<MethodMatcher> getMethodInvocationMatchers() {
        ImmutableList.Builder builder = ImmutableList.builder().add((Object)MethodMatcher.create().typeDefinition("org.apache.commons.codec.digest.DigestUtils").name("getDigest").addParameter(JAVA_LANG_STRING));
        for (String methodName : ALGORITHM_BY_METHOD_NAME.keySet()) {
            builder.add((Object)MethodMatcher.create().typeDefinition("org.apache.commons.codec.digest.DigestUtils").name(methodName).withAnyParameters());
        }
        for (String cryptoApi : CRYPTO_APIS) {
            builder.add((Object)MethodMatcher.create().typeDefinition(cryptoApi).name(GET_INSTANCE).addParameter(JAVA_LANG_STRING)).add((Object)MethodMatcher.create().typeDefinition(cryptoApi).name(GET_INSTANCE).addParameter(JAVA_LANG_STRING).addParameter(TypeCriteria.anyType()));
        }
        for (DeprecatedSpringPasswordEncoder pe : DeprecatedSpringPasswordEncoder.values()) {
            builder.add((Object)MethodMatcher.create().typeDefinition(pe.classFqn).name(pe.methodName).withAnyParameters());
        }
        for (String methodName : ImmutableList.of((Object)"md5", (Object)"sha1")) {
            builder.add((Object)MethodMatcher.create().typeDefinition("com.google.common.hash.Hashing").name(methodName).withoutParameter());
        }
        return builder.build();
    }

    @Override
    protected void onMethodInvocationFound(MethodInvocationTree mit) {
        IdentifierTree methodName = ExpressionUtils.methodName((MethodInvocationTree)mit);
        String message = DeprecatedSpringPasswordEncoder.MESSAGE_PER_CLASS.get(methodName.symbol().owner().type().fullyQualifiedName());
        if (message != null) {
            this.reportIssue((Tree)methodName, message);
            return;
        }
        InsecureAlgorithm algorithm = ALGORITHM_BY_METHOD_NAME.get(methodName.name());
        if (algorithm == null) {
            algorithm = DeprecatedHashAlgorithmCheck.algorithm((ExpressionTree)mit.arguments().get(0)).orElse(null);
        }
        if (algorithm != null) {
            this.reportIssue((Tree)methodName, "Use a stronger hashing algorithm than " + algorithm.toString() + ".");
        }
    }

    @Override
    protected void onConstructorFound(NewClassTree newClassTree) {
        String message = DeprecatedSpringPasswordEncoder.MESSAGE_PER_CLASS.get(newClassTree.identifier().symbolType().fullyQualifiedName());
        this.reportIssue((Tree)newClassTree.identifier(), message);
    }

    private static Optional<InsecureAlgorithm> algorithm(ExpressionTree invocationArgument) {
        ExpressionTree expectedAlgorithm = invocationArgument;
        ExpressionTree defaultPropertyValue = JavaPropertiesHelper.retrievedPropertyDefaultValue(invocationArgument);
        if (defaultPropertyValue != null) {
            expectedAlgorithm = defaultPropertyValue;
        }
        if (expectedAlgorithm.is(new Tree.Kind[]{Tree.Kind.STRING_LITERAL})) {
            String algorithmName = LiteralUtils.trimQuotes((String)((LiteralTree)expectedAlgorithm).value());
            return Arrays.stream(InsecureAlgorithm.values()).filter(alg -> alg.match(algorithmName)).findFirst();
        }
        return Optional.empty();
    }

    private static enum DeprecatedSpringPasswordEncoder {
        MD5("org.springframework.security.authentication.encoding.Md5PasswordEncoder", "<init>"),
        SHA("org.springframework.security.authentication.encoding.ShaPasswordEncoder", "<init>"),
        LDAP("org.springframework.security.crypto.password.LdapShaPasswordEncoder", "<init>"),
        MD4("org.springframework.security.crypto.password.Md4PasswordEncoder", "<init>"),
        MESSAGE_DIGEST("org.springframework.security.crypto.password.MessageDigestPasswordEncoder", "<init>"),
        STANDARD("org.springframework.security.crypto.password.StandardPasswordEncoder", "<init>"),
        NO_OP("org.springframework.security.crypto.password.NoOpPasswordEncoder", "getInstance");

        private static final String MESSAGE_FORMAT = "Don't rely on %s because it is deprecated and use a stronger hashing algorithm.";
        protected static final Map<String, String> MESSAGE_PER_CLASS;
        private final String classFqn;
        private final String methodName;
        private final String className;

        private DeprecatedSpringPasswordEncoder(String fqn, String methodName) {
            this.classFqn = fqn;
            this.methodName = methodName;
            String[] fqnParts = fqn.split("\\.");
            this.className = fqnParts[fqnParts.length - 1];
        }

        static {
            MESSAGE_PER_CLASS = new HashMap<String, String>();
            MESSAGE_PER_CLASS.put(DeprecatedSpringPasswordEncoder.MD5.classFqn, "Use a stronger hashing algorithm than MD5.");
            MESSAGE_PER_CLASS.put(DeprecatedSpringPasswordEncoder.SHA.classFqn, "Don't rely on " + DeprecatedSpringPasswordEncoder.SHA.className + " because it is deprecated.");
            MESSAGE_PER_CLASS.put(DeprecatedSpringPasswordEncoder.LDAP.classFqn, String.format(MESSAGE_FORMAT, DeprecatedSpringPasswordEncoder.LDAP.className));
            MESSAGE_PER_CLASS.put(DeprecatedSpringPasswordEncoder.MD4.classFqn, String.format(MESSAGE_FORMAT, DeprecatedSpringPasswordEncoder.MD4.className));
            MESSAGE_PER_CLASS.put(DeprecatedSpringPasswordEncoder.MESSAGE_DIGEST.classFqn, String.format(MESSAGE_FORMAT, DeprecatedSpringPasswordEncoder.MESSAGE_DIGEST.className));
            MESSAGE_PER_CLASS.put(DeprecatedSpringPasswordEncoder.NO_OP.classFqn, "Use a stronger hashing algorithm than this fake one.");
            MESSAGE_PER_CLASS.put(DeprecatedSpringPasswordEncoder.STANDARD.classFqn, "Use a stronger hashing algorithm.");
        }
    }

    static enum InsecureAlgorithm {
        MD2,
        MD4,
        MD5,
        MD6,
        RIPEMD160,
        SHA1{

            public String toString() {
                return "SHA-1";
            }
        }
        ,
        DSA{

            @Override
            boolean match(String algorithm) {
                return "DSA".equals(algorithm);
            }
        };


        boolean match(String algorithm) {
            String normalizedName = algorithm.replaceAll("-", "").toLowerCase(Locale.ENGLISH);
            return normalizedName.contains(this.name().toLowerCase(Locale.ENGLISH));
        }
    }
}

