/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.apache.commons.lang.ArrayUtils;
import org.sonar.check.Rule;
import org.sonar.java.JavaVersionAwareVisitor;
import org.sonar.java.model.JavaTree;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaVersion;
import org.sonar.plugins.java.api.tree.ArrayAccessExpressionTree;
import org.sonar.plugins.java.api.tree.ArrayTypeTree;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.ConditionalExpressionTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.ParameterizedTypeTree;
import org.sonar.plugins.java.api.tree.ParenthesizedTree;
import org.sonar.plugins.java.api.tree.ReturnStatementTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;
import org.sonar.plugins.java.api.tree.TypeCastTree;
import org.sonar.plugins.java.api.tree.TypeTree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S2293")
public class DiamondOperatorCheck
extends IssuableSubscriptionVisitor
implements JavaVersionAwareVisitor {
    private static final Tree.Kind[] JAVA_7_KINDS = new Tree.Kind[]{Tree.Kind.VARIABLE, Tree.Kind.TYPE_CAST, Tree.Kind.RETURN_STATEMENT, Tree.Kind.ASSIGNMENT};
    private static final Tree.Kind[] JAVA_8_KINDS = (Tree.Kind[])ArrayUtils.addAll((Object[])JAVA_7_KINDS, (Object[])new Tree.Kind[]{Tree.Kind.CONDITIONAL_EXPRESSION});
    private Tree.Kind[] expressionKindsToCheck = JAVA_7_KINDS;

    public boolean isCompatibleWithJavaVersion(JavaVersion version) {
        if (version.isJava8Compatible()) {
            this.expressionKindsToCheck = JAVA_8_KINDS;
        }
        return version.isJava7Compatible();
    }

    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.NEW_CLASS);
    }

    public void visitNode(Tree tree) {
        TypeTree type;
        NewClassTree newClassTree = (NewClassTree)tree;
        TypeTree newTypeTree = newClassTree.identifier();
        if (newClassTree.classBody() == null && DiamondOperatorCheck.isParameterizedType(newTypeTree) && (type = DiamondOperatorCheck.getTypeFromExpression(tree.parent(), this.expressionKindsToCheck)) != null && DiamondOperatorCheck.isParameterizedType(type)) {
            this.reportIssue((Tree)((ParameterizedTypeTree)newTypeTree).typeArguments(), "Replace the type specification in this constructor call with the diamond operator (\"<>\")." + this.context.getJavaVersion().java7CompatibilityMessage());
        }
    }

    @CheckForNull
    private static TypeTree getTypeFromExpression(Tree expression, Tree.Kind[] kinds) {
        if (expression.is(kinds)) {
            TypeTreeLocator visitor = new TypeTreeLocator(kinds);
            expression.accept((TreeVisitor)visitor);
            return visitor.type;
        }
        return null;
    }

    private static boolean isParameterizedType(TypeTree type) {
        if (type.is(new Tree.Kind[]{Tree.Kind.ARRAY_TYPE})) {
            return DiamondOperatorCheck.isParameterizedType(((ArrayTypeTree)type).type());
        }
        return type.is(new Tree.Kind[]{Tree.Kind.PARAMETERIZED_TYPE}) && !((ParameterizedTypeTree)type).typeArguments().isEmpty();
    }

    private static class TypeTreeLocator
    extends BaseTreeVisitor {
        private final Tree.Kind[] kinds;
        @Nullable
        private TypeTree type = null;

        public TypeTreeLocator(Tree.Kind[] kinds) {
            this.kinds = kinds;
        }

        public void visitReturnStatement(ReturnStatementTree tree) {
            this.type = TypeTreeLocator.getMethodReturnType(tree);
        }

        public void visitTypeCast(TypeCastTree tree) {
            this.type = tree.type();
        }

        public void visitAssignmentExpression(AssignmentExpressionTree tree) {
            Tree assignedVariable = TypeTreeLocator.getAssignedVariable(tree.variable());
            if (assignedVariable != null) {
                this.type = DiamondOperatorCheck.getTypeFromExpression(assignedVariable, this.kinds);
            }
        }

        public void visitVariable(VariableTree tree) {
            this.type = tree.type();
        }

        public void visitConditionalExpression(ConditionalExpressionTree tree) {
            this.type = DiamondOperatorCheck.getTypeFromExpression(tree.parent(), this.kinds);
        }

        @CheckForNull
        private static TypeTree getMethodReturnType(ReturnStatementTree returnStatementTree) {
            MethodTree methodTree = TypeTreeLocator.getParentMethod((Tree)returnStatementTree);
            if (methodTree != null) {
                return methodTree.returnType();
            }
            return null;
        }

        @CheckForNull
        private static MethodTree getParentMethod(Tree tree) {
            Tree result;
            for (result = tree; result != null && !result.is(new Tree.Kind[]{Tree.Kind.METHOD}); result = result.parent()) {
            }
            return (MethodTree)result;
        }

        @CheckForNull
        private static Tree getAssignedVariable(ExpressionTree expression) {
            IdentifierTree identifier;
            switch (expression.kind()) {
                case ARRAY_ACCESS_EXPRESSION: {
                    return TypeTreeLocator.getAssignedVariable(((ArrayAccessExpressionTree)expression).expression());
                }
                case TYPE_CAST: {
                    return TypeTreeLocator.getAssignedVariable(((TypeCastTree)expression).expression());
                }
                case PARENTHESIZED_EXPRESSION: {
                    return TypeTreeLocator.getAssignedVariable(((ParenthesizedTree)expression).expression());
                }
                case IDENTIFIER: {
                    identifier = (IdentifierTree)expression;
                    break;
                }
                case MEMBER_SELECT: {
                    identifier = ((MemberSelectExpressionTree)expression).identifier();
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected expression " + expression.kind().name() + " at: " + ((JavaTree)expression).getLine());
                }
            }
            return identifier.symbol().declaration();
        }
    }
}

