/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.RspecKey;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="EmptyStatementUsageCheck")
@RspecKey(value="S1116")
public class EmptyStatementUsageCheck
extends IssuableSubscriptionVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.EMPTY_STATEMENT);
    }

    public void visitNode(Tree tree) {
        if (EmptyStatementUsageCheck.usedForEmptyEnum(tree) || EmptyStatementUsageCheck.uniqueStatementOfLoop(tree)) {
            return;
        }
        this.reportIssue(tree, "Remove this empty statement.");
    }

    private static boolean usedForEmptyEnum(Tree tree) {
        Tree parent = tree.parent();
        if (parent.is(new Tree.Kind[]{Tree.Kind.ENUM})) {
            return ((ClassTree)parent).members().indexOf(tree) == 0;
        }
        return false;
    }

    private static boolean uniqueStatementOfLoop(Tree tree) {
        return tree.parent().is(new Tree.Kind[]{Tree.Kind.WHILE_STATEMENT, Tree.Kind.FOR_EACH_STATEMENT, Tree.Kind.FOR_STATEMENT, Tree.Kind.DO_STATEMENT});
    }
}

