/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.matcher.MethodMatcher;
import org.sonar.java.matcher.MethodMatcherCollection;
import org.sonar.java.matcher.NameCriteria;
import org.sonar.java.resolve.JavaType;
import org.sonar.java.resolve.ParametrizedTypeJavaType;
import org.sonar.java.resolve.TypeVariableJavaType;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TypeTree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S1641")
public class EnumSetCheck
extends IssuableSubscriptionVisitor {
    private static final MethodMatcher COLLECTIONS_UNMODIFIABLE = MethodMatcher.create().typeDefinition("java.util.Collections").name("unmodifiableSet").withAnyParameters();
    private static final MethodMatcherCollection SET_CREATION_METHODS = MethodMatcherCollection.create((MethodMatcher[])new MethodMatcher[]{MethodMatcher.create().typeDefinition("java.util.Set").name("of").withAnyParameters(), MethodMatcher.create().typeDefinition("com.google.common.collect.ImmutableSet").name("of").withAnyParameters(), MethodMatcher.create().typeDefinition("com.google.common.collect.Sets").name(NameCriteria.any()).withAnyParameters()});

    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.VARIABLE);
    }

    public void visitNode(Tree tree) {
        if (!this.hasSemantic()) {
            return;
        }
        VariableTree variableTree = (VariableTree)tree;
        ExpressionTree initializer = variableTree.initializer();
        if (initializer == null) {
            return;
        }
        if (initializer.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION})) {
            MethodInvocationTree mit = (MethodInvocationTree)initializer;
            if (COLLECTIONS_UNMODIFIABLE.matches(mit)) {
                initializer = (ExpressionTree)mit.arguments().get(0);
            } else if (!SET_CREATION_METHODS.anyMatch(mit) || "immutableEnumSet".equals(mit.symbol().name())) {
                return;
            }
        }
        this.checkIssue(initializer.symbolType(), (Tree)initializer, variableTree.type());
    }

    private void checkIssue(Type type, Tree reportTree, TypeTree typeTree) {
        if (type.isSubtypeOf("java.util.Set") && !type.isSubtypeOf("java.util.EnumSet") && type instanceof ParametrizedTypeJavaType) {
            JavaType typeParameter;
            ParametrizedTypeJavaType parametrizedType = (ParametrizedTypeJavaType)type;
            List typeParameters = parametrizedType.typeParameters();
            Type variableType = typeTree.symbolType();
            if (typeParameters.isEmpty() && variableType instanceof ParametrizedTypeJavaType) {
                parametrizedType = (ParametrizedTypeJavaType)variableType;
                typeParameters = parametrizedType.typeParameters();
            }
            if (!typeParameters.isEmpty() && (typeParameter = parametrizedType.substitution((TypeVariableJavaType)typeParameters.get(0))) != null && typeParameter.symbol().isEnum()) {
                this.reportIssue(reportTree, "Convert this Set to an EnumSet.");
            }
        }
    }
}

