/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.java.matcher.MethodMatcher;
import org.sonar.java.matcher.TypeCriteria;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S2204")
public class EqualsOnAtomicClassCheck
extends AbstractMethodDetection {
    @Override
    protected List<MethodMatcher> getMethodInvocationMatchers() {
        return ImmutableList.of((Object)EqualsOnAtomicClassCheck.equalsInvocationMatcher("java.util.concurrent.atomic.AtomicBoolean"), (Object)EqualsOnAtomicClassCheck.equalsInvocationMatcher("java.util.concurrent.atomic.AtomicInteger"), (Object)EqualsOnAtomicClassCheck.equalsInvocationMatcher("java.util.concurrent.atomic.AtomicLong"));
    }

    private static MethodMatcher equalsInvocationMatcher(String fullyQualifiedName) {
        return MethodMatcher.create().callSite(TypeCriteria.is((String)fullyQualifiedName)).name("equals").addParameter("java.lang.Object");
    }

    @Override
    protected void onMethodInvocationFound(MethodInvocationTree mit) {
        this.reportIssue((Tree)ExpressionUtils.methodName((MethodInvocationTree)mit), "Use \".get()\" to retrieve the value and compare it instead.");
    }
}

