/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.java.checks.helpers.ConstantUtils;
import org.sonar.java.checks.helpers.IdentifierUtils;
import org.sonar.java.matcher.MethodMatcher;
import org.sonar.java.model.LiteralUtils;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.tree.Arguments;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.LiteralTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S2068")
public class HardCodedCredentialsCheck
extends IssuableSubscriptionVisitor {
    private static final String DEFAULT_CREDENTIAL_WORDS = "password,passwd,pwd,passphrase,java.naming.security.credentials";
    private static final String JAVA_LANG_STRING = "java.lang.String";
    private static final String JAVA_LANG_OBJECT = "java.lang.Object";
    private static final MethodMatcher PASSWORD_AUTHENTICATION_CONSTRUCTOR = MethodMatcher.create().typeDefinition("java.net.PasswordAuthentication").name("<init>").addParameter("java.lang.String").addParameter("char[]");
    private static final MethodMatcher STRING_TO_CHAR_ARRAY = MethodMatcher.create().typeDefinition("java.lang.String").name("toCharArray").withoutParameter();
    private static final MethodMatcher EQUALS_MATCHER = MethodMatcher.create().name("equals").parameters(new String[]{"java.lang.Object"});
    private static final MethodMatcher GET_CONNECTION_MATCHER = MethodMatcher.create().typeDefinition("java.sql.DriverManager").name("getConnection").withAnyParameters();
    private static final int GET_CONNECTION_PASSWORD_ARGUMENT = 2;
    @RuleProperty(key="credentialWords", description="Comma separated list of words identifying potential credentials", defaultValue="password,passwd,pwd,passphrase,java.naming.security.credentials")
    public String credentialWords = "password,passwd,pwd,passphrase,java.naming.security.credentials";
    private List<Pattern> variablePatterns = null;
    private List<Pattern> literalPatterns = null;

    private Stream<Pattern> variablePatterns() {
        if (this.variablePatterns == null) {
            this.variablePatterns = this.toPatterns("");
        }
        return this.variablePatterns.stream();
    }

    private Stream<Pattern> literalPatterns() {
        if (this.literalPatterns == null) {
            this.literalPatterns = this.toPatterns("=\\S.");
        }
        return this.literalPatterns.stream();
    }

    private List<Pattern> toPatterns(String suffix) {
        return Stream.of(this.credentialWords.split(",")).map(String::trim).map(word -> Pattern.compile("(" + word + ")" + suffix, 2)).collect(Collectors.toList());
    }

    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.STRING_LITERAL, (Object)Tree.Kind.VARIABLE, (Object)Tree.Kind.ASSIGNMENT, (Object)Tree.Kind.NEW_CLASS, (Object)Tree.Kind.METHOD_INVOCATION);
    }

    public void visitNode(Tree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.STRING_LITERAL})) {
            this.handleStringLiteral((LiteralTree)tree);
        } else if (tree.is(new Tree.Kind[]{Tree.Kind.VARIABLE})) {
            this.handleVariable((VariableTree)tree);
        } else if (tree.is(new Tree.Kind[]{Tree.Kind.ASSIGNMENT})) {
            this.handleAssignment((AssignmentExpressionTree)tree);
        } else if (tree.is(new Tree.Kind[]{Tree.Kind.NEW_CLASS})) {
            this.handleConstructor((NewClassTree)tree);
        } else {
            this.handleMethodInvocation((MethodInvocationTree)tree);
        }
    }

    private Optional<String> isSettingPassword(MethodInvocationTree tree) {
        Arguments arguments = tree.arguments();
        if (arguments.size() == 2 && HardCodedCredentialsCheck.isArgumentsSuperTypeOfString((List<ExpressionTree>)arguments) && HardCodedCredentialsCheck.isNotEmptyString((ExpressionTree)arguments.get(1))) {
            return this.isPassword((ExpressionTree)arguments.get(0));
        }
        return Optional.empty();
    }

    private Optional<String> isPassword(ExpressionTree argument) {
        String value = IdentifierUtils.getValue(argument, ConstantUtils::resolveAsStringConstant);
        if (StringUtils.isEmpty((String)value)) {
            return Optional.empty();
        }
        return this.variablePatterns().map(pattern -> pattern.matcher(value)).filter(Matcher::matches).map(matcher -> matcher.group(1)).findAny();
    }

    private Optional<String> isPasswordVariableName(IdentifierTree identifierTree) {
        String identifierName = identifierTree.name();
        return this.variablePatterns().map(pattern -> pattern.matcher(identifierName)).filter(Matcher::find).map(matcher -> matcher.group(1)).findAny();
    }

    private Optional<String> isPasswordVariable(ExpressionTree variable) {
        if (variable.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
            return this.isPasswordVariableName(((MemberSelectExpressionTree)variable).identifier());
        }
        if (variable.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
            return this.isPasswordVariableName((IdentifierTree)variable);
        }
        return Optional.empty();
    }

    private static boolean isCallOnStringLiteral(ExpressionTree expr) {
        return expr.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT}) && HardCodedCredentialsCheck.isNotEmptyString(((MemberSelectExpressionTree)expr).expression());
    }

    private void handleStringLiteral(LiteralTree tree) {
        String cleanedLiteral = LiteralUtils.trimQuotes((String)tree.value());
        this.literalPatterns().map(pattern -> pattern.matcher(cleanedLiteral)).filter(Matcher::find).map(matcher -> matcher.group(1)).findAny().ifPresent(credential -> this.report((Tree)tree, (String)credential));
    }

    private void handleVariable(VariableTree tree) {
        IdentifierTree variable = tree.simpleName();
        this.isPasswordVariableName(variable).filter(passwordVariableName -> HardCodedCredentialsCheck.isNotEmptyStringOrCharArrayFromString(tree.initializer())).ifPresent(passwordVariableName -> this.report((Tree)variable, (String)passwordVariableName));
    }

    private void handleAssignment(AssignmentExpressionTree tree) {
        ExpressionTree variable = tree.variable();
        this.isPasswordVariable(variable).filter(passwordVariableName -> HardCodedCredentialsCheck.isNotEmptyStringOrCharArrayFromString(tree.expression())).ifPresent(passwordVariableName -> this.report((Tree)variable, (String)passwordVariableName));
    }

    private static boolean isArgumentsSuperTypeOfString(List<ExpressionTree> arguments) {
        return arguments.stream().allMatch(arg -> arg.symbolType().is(JAVA_LANG_STRING) || arg.symbolType().is(JAVA_LANG_OBJECT));
    }

    private static boolean isNotEmptyStringOrCharArrayFromString(@Nullable ExpressionTree expression) {
        if (expression != null && expression.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION})) {
            MethodInvocationTree mit = (MethodInvocationTree)expression;
            return STRING_TO_CHAR_ARRAY.matches(mit) && HardCodedCredentialsCheck.isCallOnStringLiteral(mit.methodSelect());
        }
        return HardCodedCredentialsCheck.isNotEmptyString(expression);
    }

    private static boolean isNotEmptyString(@Nullable ExpressionTree expression) {
        if (expression == null) {
            return false;
        }
        String literal = IdentifierUtils.getValue(expression, ConstantUtils::resolveAsStringConstant);
        return literal != null && !literal.trim().isEmpty();
    }

    private void handleConstructor(NewClassTree tree) {
        MethodInvocationTree mit;
        if (!PASSWORD_AUTHENTICATION_CONSTRUCTOR.matches(tree)) {
            return;
        }
        ExpressionTree secondArg = (ExpressionTree)tree.arguments().get(1);
        if (secondArg.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION}) && STRING_TO_CHAR_ARRAY.matches(mit = (MethodInvocationTree)secondArg) && HardCodedCredentialsCheck.isCallOnStringLiteral(mit.methodSelect())) {
            this.reportIssue((Tree)tree, "Remove this hard-coded password.");
        }
    }

    private void handleMethodInvocation(MethodInvocationTree mit) {
        ExpressionTree methodSelect = mit.methodSelect();
        if (EQUALS_MATCHER.matches(mit) && methodSelect.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
            this.handleEqualsMethod(mit, (MemberSelectExpressionTree)methodSelect);
        } else if (GET_CONNECTION_MATCHER.matches(mit)) {
            this.handleGetConnectionMethod(mit);
        } else {
            this.isSettingPassword(mit).ifPresent(settingPassword -> this.report((Tree)methodSelect, (String)settingPassword));
        }
    }

    private void handleEqualsMethod(MethodInvocationTree mit, MemberSelectExpressionTree methodSelect) {
        ExpressionTree leftExpression = methodSelect.expression();
        ExpressionTree rightExpression = (ExpressionTree)mit.arguments().get(0);
        this.isPasswordVariable(leftExpression).filter(passwordVariableName -> HardCodedCredentialsCheck.isNotEmptyString(rightExpression)).ifPresent(passwordVariableName -> this.report((Tree)leftExpression, (String)passwordVariableName));
        this.isPasswordVariable(rightExpression).filter(passwordVariableName -> HardCodedCredentialsCheck.isNotEmptyString(leftExpression)).ifPresent(passwordVariableName -> this.report((Tree)rightExpression, (String)passwordVariableName));
    }

    private void handleGetConnectionMethod(MethodInvocationTree mit) {
        ExpressionTree expression;
        if (mit.arguments().size() > 2 && HardCodedCredentialsCheck.isNotEmptyString(expression = (ExpressionTree)mit.arguments().get(2))) {
            this.reportIssue((Tree)expression, "Remove this hard-coded password.");
        }
    }

    private void report(Tree tree, String match) {
        this.reportIssue(tree, "'" + match + "' detected in this expression, review this potentially hard-coded credential.");
    }
}

