/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.model.SyntacticEquivalence;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.BlockTree;
import org.sonar.plugins.java.api.tree.CaseGroupTree;
import org.sonar.plugins.java.api.tree.IfStatementTree;
import org.sonar.plugins.java.api.tree.StatementTree;
import org.sonar.plugins.java.api.tree.SwitchStatementTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S1871")
public class IdenticalCasesInSwitchCheck
extends IssuableSubscriptionVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.SWITCH_STATEMENT, (Object)Tree.Kind.IF_STATEMENT);
    }

    public void visitNode(Tree node) {
        if (node.is(new Tree.Kind[]{Tree.Kind.SWITCH_STATEMENT})) {
            boolean allBranchesSameWithoutDefault;
            SwitchStatementTree switchStatement = (SwitchStatementTree)node;
            Multimap<CaseGroupTree, CaseGroupTree> identicalBranches = this.checkSwitchStatement(switchStatement);
            boolean allBranchesSame = IdenticalCasesInSwitchCheck.allBranchesSame(identicalBranches, switchStatement.cases().size());
            boolean bl = allBranchesSameWithoutDefault = allBranchesSame && !IdenticalCasesInSwitchCheck.hasDefaultClause(switchStatement);
            if (!allBranchesSame || allBranchesSameWithoutDefault) {
                identicalBranches.asMap().forEach((first, others) -> {
                    if (!IdenticalCasesInSwitchCheck.isTrivialCase(first.body()) || allBranchesSameWithoutDefault) {
                        others.forEach(other -> this.createIssue((Tree)other, IdenticalCasesInSwitchCheck.issueMessage("case", (Tree)first), (Tree)first));
                    }
                });
            }
        } else if (node.is(new Tree.Kind[]{Tree.Kind.IF_STATEMENT}) && !node.parent().is(new Tree.Kind[]{Tree.Kind.IF_STATEMENT})) {
            IfStatementTree ifStatement = (IfStatementTree)node;
            IfElseChain ifElseChain = IdenticalCasesInSwitchCheck.checkIfStatement(ifStatement);
            this.reportIdenticalIfChainBranches(ifElseChain.branches, ifElseChain.totalBranchCount, IdenticalCasesInSwitchCheck.hasElseClause(ifStatement));
        }
    }

    protected static boolean allBranchesSame(Multimap<? extends Tree, ? extends Tree> identicalBranches, int size) {
        return identicalBranches.keySet().size() == 1 && identicalBranches.size() == size - 1;
    }

    private static boolean isTrivialCase(List<StatementTree> body) {
        return body.size() == 1 || body.size() == 2 && body.get(1).is(new Tree.Kind[]{Tree.Kind.BREAK_STATEMENT});
    }

    protected Multimap<CaseGroupTree, CaseGroupTree> checkSwitchStatement(SwitchStatementTree node) {
        HashMultimap identicalBranches = HashMultimap.create();
        int index = 0;
        List cases = node.cases();
        for (CaseGroupTree caseGroupTree : cases) {
            ++index;
            if (identicalBranches.containsValue((Object)caseGroupTree)) continue;
            for (int i = index; i < cases.size(); ++i) {
                if (!SyntacticEquivalence.areEquivalent((List)caseGroupTree.body(), (List)((CaseGroupTree)cases.get(i)).body())) continue;
                identicalBranches.put((Object)caseGroupTree, (Object)((CaseGroupTree)cases.get(i)));
            }
        }
        return identicalBranches;
    }

    protected static IfElseChain checkIfStatement(IfStatementTree node) {
        IfElseChain ifElseChain = new IfElseChain();
        ifElseChain.totalBranchCount = 1;
        ArrayList<StatementTree> allBranches = new ArrayList<StatementTree>();
        allBranches.add(node.thenStatement());
        StatementTree elseStatement = node.elseStatement();
        while (elseStatement != null && elseStatement.is(new Tree.Kind[]{Tree.Kind.IF_STATEMENT})) {
            IfStatementTree ifStatement = (IfStatementTree)elseStatement;
            allBranches.add(ifStatement.thenStatement());
            elseStatement = ifStatement.elseStatement();
        }
        if (elseStatement != null) {
            allBranches.add(elseStatement);
        }
        return IdenticalCasesInSwitchCheck.collectIdenticalBranches(allBranches);
    }

    private static IfElseChain collectIdenticalBranches(List<StatementTree> allBranches) {
        IfElseChain ifElseChain = new IfElseChain();
        for (int i = 0; i < allBranches.size(); ++i) {
            if (ifElseChain.branches.containsValue((Object)allBranches.get(i))) continue;
            for (int j = i + 1; j < allBranches.size(); ++j) {
                if (!SyntacticEquivalence.areEquivalent((Tree)((Tree)allBranches.get(i)), (Tree)((Tree)allBranches.get(j)))) continue;
                ifElseChain.branches.put((Object)allBranches.get(i), (Object)allBranches.get(j));
            }
        }
        ifElseChain.totalBranchCount = allBranches.size();
        return ifElseChain;
    }

    private void reportIdenticalIfChainBranches(Multimap<StatementTree, StatementTree> identicalBranches, int totalBranchCount, boolean withElseClause) {
        boolean allBranchesSameWithoutElse;
        boolean allBranchesSame = IdenticalCasesInSwitchCheck.allBranchesSame(identicalBranches, totalBranchCount);
        boolean bl = allBranchesSameWithoutElse = allBranchesSame && !withElseClause;
        if (!allBranchesSame || allBranchesSameWithoutElse) {
            identicalBranches.asMap().forEach((first, others) -> {
                if (!IdenticalCasesInSwitchCheck.isTrivialIfStatement(first) || allBranchesSameWithoutElse) {
                    others.forEach(other -> this.createIssue((Tree)other, IdenticalCasesInSwitchCheck.issueMessage("branch", (Tree)first), (Tree)first));
                }
            });
        }
    }

    private static boolean isTrivialIfStatement(StatementTree node) {
        return !node.is(new Tree.Kind[]{Tree.Kind.BLOCK}) || ((BlockTree)node).body().size() <= 1;
    }

    protected static boolean hasDefaultClause(SwitchStatementTree switchStatement) {
        return switchStatement.cases().stream().flatMap(caseGroupTree -> caseGroupTree.labels().stream()).anyMatch(caseLabelTree -> caseLabelTree.caseOrDefaultKeyword().text().equals("default"));
    }

    protected static boolean hasElseClause(IfStatementTree ifStatement) {
        StatementTree elseStatement = ifStatement.elseStatement();
        while (elseStatement != null && elseStatement.is(new Tree.Kind[]{Tree.Kind.IF_STATEMENT})) {
            elseStatement = ((IfStatementTree)elseStatement).elseStatement();
        }
        return elseStatement != null;
    }

    private void createIssue(Tree node, String message, Tree secondary) {
        this.reportIssue(node, message, (List)ImmutableList.of((Object)new JavaFileScannerContext.Location("Original", secondary)), null);
    }

    private static String issueMessage(String type, Tree node) {
        return "This " + type + "'s code block is the same as the block for the " + type + " on line " + node.firstToken().line() + ".";
    }

    protected static class IfElseChain {
        Multimap<StatementTree, StatementTree> branches = HashMultimap.create();
        int totalBranchCount;

        protected IfElseChain() {
        }
    }
}

