/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.matcher.MethodMatcher;
import org.sonar.java.matcher.MethodMatcherCollection;
import org.sonar.java.matcher.TypeCriteria;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.tree.ExpressionStatementTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S2674")
public class IgnoredStreamReturnValueCheck
extends IssuableSubscriptionVisitor {
    private static final MethodMatcherCollection MATCHERS = MethodMatcherCollection.create((MethodMatcher[])new MethodMatcher[]{IgnoredStreamReturnValueCheck.inputStreamInvocationMatcher("skip", "long"), IgnoredStreamReturnValueCheck.inputStreamInvocationMatcher("read", "byte[]")});

    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.EXPRESSION_STATEMENT);
    }

    public void visitNode(Tree tree) {
        MethodInvocationTree mit;
        if (!this.hasSemantic()) {
            return;
        }
        ExpressionTree statement = ((ExpressionStatementTree)tree).expression();
        if (statement.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION}) && MATCHERS.anyMatch(mit = (MethodInvocationTree)statement)) {
            this.reportIssue((Tree)ExpressionUtils.methodName((MethodInvocationTree)mit), "Check the return value of the \"" + mit.symbol().name() + "\" call to see how many bytes were read.");
        }
    }

    private static MethodMatcher inputStreamInvocationMatcher(String methodName, String parameterType) {
        return MethodMatcher.create().typeDefinition(TypeCriteria.subtypeOf((String)"java.io.InputStream")).name(methodName).addParameter(parameterType);
    }
}

