/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.InstanceOfTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S1850")
public class InstanceOfAlwaysTrueCheck
extends IssuableSubscriptionVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.INSTANCE_OF);
    }

    public void visitNode(Tree tree) {
        Type instanceOf;
        InstanceOfTree instanceOfTree = (InstanceOfTree)tree;
        Type expressionType = instanceOfTree.expression().symbolType();
        if (expressionType.isSubtypeOf(instanceOf = instanceOfTree.type().symbolType()) && !instanceOfTree.expression().is(new Tree.Kind[]{Tree.Kind.NULL_LITERAL})) {
            this.reportIssue((Tree)instanceOfTree.instanceofKeyword(), "Remove this useless \"instanceof\" operator; it will always return \"true\". ");
        }
    }
}

