/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.BooleanUtils;
import org.sonar.check.Rule;
import org.sonar.java.resolve.ClassJavaType;
import org.sonar.java.resolve.JavaSymbol;
import org.sonar.java.resolve.JavaType;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.SymbolMetadata;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S3242")
public class LeastSpecificTypeCheck
extends IssuableSubscriptionVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.METHOD);
    }

    public void visitNode(Tree tree) {
        if (!this.hasSemantic()) {
            return;
        }
        MethodTree methodTree = (MethodTree)tree;
        Symbol.MethodSymbol methodSymbol = methodTree.symbol();
        if (!methodSymbol.isPublic() || !Boolean.FALSE.equals(methodTree.isOverriding()) || LeastSpecificTypeCheck.isOverloaded(methodSymbol)) {
            return;
        }
        boolean springInjectionAnnotated = LeastSpecificTypeCheck.isSpringInjectionAnnotated(methodSymbol.metadata());
        methodTree.parameters().stream().map(VariableTree::symbol).filter(p -> p.type().isClass() && !p.type().symbol().isEnum() && !p.type().is("java.lang.String")).filter(p -> !springInjectionAnnotated || !p.type().is("java.util.Collection")).forEach(p -> this.handleParameter((Symbol)p, springInjectionAnnotated));
    }

    private static boolean isOverloaded(Symbol.MethodSymbol methodSymbol) {
        return ((Symbol.TypeSymbol)methodSymbol.owner()).lookupSymbols(methodSymbol.name()).size() > 1;
    }

    private void handleParameter(Symbol parameter, boolean springInjectionAnnotated) {
        Type leastSpecificType = LeastSpecificTypeCheck.findLeastSpecificType(parameter);
        if (parameter.type() != leastSpecificType && !leastSpecificType.is("java.lang.Object")) {
            String suggestedType = LeastSpecificTypeCheck.getSuggestedType(springInjectionAnnotated, leastSpecificType);
            this.reportIssue(parameter.declaration(), String.format("Use '%s' here; it is a more general type than '%s'.", suggestedType, parameter.type().name()));
        }
    }

    private static String getSuggestedType(boolean springInjectionAnnotated, Type leastSpecificType) {
        if (springInjectionAnnotated && leastSpecificType.is("java.lang.Iterable")) {
            return "java.util.Collection";
        }
        return leastSpecificType.fullyQualifiedName().replace('$', '.');
    }

    private static Type findLeastSpecificType(Symbol parameter) {
        InheritanceGraph inheritanceGraph = new InheritanceGraph(parameter.type());
        for (IdentifierTree usage : parameter.usages()) {
            MethodInvocationTree mit;
            Tree parent;
            for (parent = usage.parent(); parent != null && !parent.is(new Tree.Kind[]{Tree.Kind.ARGUMENTS, Tree.Kind.METHOD_INVOCATION, Tree.Kind.EXPRESSION_STATEMENT, Tree.Kind.FOR_EACH_STATEMENT}); parent = parent.parent()) {
            }
            if (parent == null || parent.is(new Tree.Kind[]{Tree.Kind.EXPRESSION_STATEMENT, Tree.Kind.ARGUMENTS})) {
                return parameter.type();
            }
            if (parent.is(new Tree.Kind[]{Tree.Kind.FOR_EACH_STATEMENT})) {
                LeastSpecificTypeCheck.findIteratorMethod(parameter).ifPresent(x$0 -> inheritanceGraph.update(x$0));
                continue;
            }
            if (!parent.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION}) || !LeastSpecificTypeCheck.isMethodInvocationOnParameter(parameter, mit = (MethodInvocationTree)parent)) continue;
            inheritanceGraph.update(mit.symbol());
        }
        return inheritanceGraph.leastSpecificType();
    }

    private static Optional<Symbol> findIteratorMethod(Symbol parameter) {
        return parameter.type().symbol().lookupSymbols("iterator").stream().filter(Symbol::isMethodSymbol).filter(s -> ((Symbol.MethodSymbol)s).parameterTypes().isEmpty()).findFirst();
    }

    private static boolean isMethodInvocationOnParameter(Symbol parameter, MethodInvocationTree mit) {
        MemberSelectExpressionTree mset;
        if (mit.methodSelect().is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT}) && (mset = (MemberSelectExpressionTree)mit.methodSelect()).expression().is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
            Symbol symbol = ((IdentifierTree)mset.expression()).symbol();
            return symbol == parameter;
        }
        return false;
    }

    private static boolean isSpringInjectionAnnotated(SymbolMetadata metadata) {
        return metadata.isAnnotatedWith("org.springframework.beans.factory.annotation.Autowired") || metadata.isAnnotatedWith("javax.inject.Inject") || metadata.isAnnotatedWith("javax.annotation.Resource");
    }

    private static class InheritanceGraph {
        private final Type startType;
        private List<List<Type>> chains = null;

        private InheritanceGraph(Type type) {
            this.startType = type;
        }

        private void update(Symbol m) {
            if (this.chains == null) {
                this.chains = this.computeChains(m, this.startType);
            } else {
                this.refineChains(m);
            }
        }

        private List<List<Type>> computeChains(Symbol m, Type type) {
            boolean isSpecialization;
            Symbol.TypeSymbol typeSymbol = type.symbol();
            Set superTypes = ((JavaSymbol.TypeJavaSymbol)typeSymbol).directSuperTypes();
            List<List<Type>> result = superTypes.stream().flatMap(superType -> this.computeChains(m, (Type)superType).stream()).peek(c -> c.add(type)).collect(Collectors.toList());
            boolean definesSymbol = InheritanceGraph.definesSymbol(m, typeSymbol);
            boolean bl = isSpecialization = !((JavaType)this.startType).isParameterized() && ((JavaType)type).isParameterized();
            if (definesSymbol && !isSpecialization && result.isEmpty()) {
                result.add(Lists.newArrayList((Object[])new Type[]{type}));
            }
            return result;
        }

        private static boolean definesOrInheritsSymbol(Symbol symbol, JavaSymbol.TypeJavaSymbol typeSymbol) {
            return InheritanceGraph.definesSymbol(symbol, (Symbol.TypeSymbol)typeSymbol) || typeSymbol.superTypes().stream().anyMatch(superType -> InheritanceGraph.definesSymbol(symbol, superType.symbol()));
        }

        private static boolean definesSymbol(Symbol m, Symbol.TypeSymbol typeSymbol) {
            return typeSymbol.memberSymbols().stream().anyMatch(s -> InheritanceGraph.isOverriding(m, s, (ClassJavaType)typeSymbol.type()));
        }

        private void refineChains(Symbol m) {
            for (List<Type> chain : this.chains) {
                Type type;
                Iterator<Type> chainIterator = chain.iterator();
                while (chainIterator.hasNext() && !InheritanceGraph.definesOrInheritsSymbol(m, (JavaSymbol.TypeJavaSymbol)(type = chainIterator.next()).symbol())) {
                    chainIterator.remove();
                }
            }
        }

        private Type leastSpecificType() {
            if (this.chains == null) {
                return this.startType;
            }
            this.chains.forEach(c -> c.removeIf(t -> !t.symbol().isPublic()));
            if (this.chains.stream().allMatch(List::isEmpty)) {
                return this.startType;
            }
            this.chains.sort(Comparator.comparingInt(List::size).thenComparing(chain -> ((Type)chain.get(0)).symbol().isInterface(), Boolean::compare).thenComparing(chain -> (Type)chain.get(0), Comparator.comparing(Type::fullyQualifiedName).reversed()).reversed());
            List<Type> longestChain = this.chains.get(0);
            return longestChain.get(0);
        }

        private static boolean isOverriding(Symbol s1, Symbol s2, ClassJavaType superClass) {
            return s1.isMethodSymbol() && s2.isMethodSymbol() && InheritanceGraph.isOverridingMethod((JavaSymbol.MethodJavaSymbol)s1, (JavaSymbol.MethodJavaSymbol)s2, superClass);
        }

        private static boolean isOverridingMethod(JavaSymbol.MethodJavaSymbol s1, JavaSymbol.MethodJavaSymbol s2, ClassJavaType superClass) {
            return s1.name().equals(s2.name()) && BooleanUtils.isTrue((Boolean)s1.checkOverridingParameters(s2, superClass));
        }
    }
}

