/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.java.matcher.MethodMatcher;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S2127")
public class LongBitsToDoubleOnIntCheck
extends AbstractMethodDetection {
    @Override
    protected List<MethodMatcher> getMethodInvocationMatchers() {
        return ImmutableList.builder().add((Object)MethodMatcher.create().typeDefinition("java.lang.Double").name("longBitsToDouble").addParameter("long")).build();
    }

    @Override
    protected void onMethodInvocationFound(MethodInvocationTree mit) {
        Type symbolType = ((ExpressionTree)mit.arguments().get(0)).symbolType();
        if (!symbolType.is("long") && !symbolType.is("java.lang.Long")) {
            this.reportIssue((Tree)ExpressionUtils.methodName((MethodInvocationTree)mit), "Remove this \"Double.longBitsToDouble\" call.");
        }
    }
}

