/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.BinaryExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;

@Rule(key="S2178")
public class NonShortCircuitLogicCheck
extends IssuableSubscriptionVisitor {
    private static final Map<String, String> REPLACEMENTS = ImmutableMap.of((Object)"&", (Object)"&&", (Object)"|", (Object)"||");

    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.AND, (Object)Tree.Kind.OR);
    }

    public void visitNode(Tree tree) {
        BinaryExpressionTree binaryExpressionTree = (BinaryExpressionTree)tree;
        if (NonShortCircuitLogicCheck.isBoolean(binaryExpressionTree.leftOperand().symbolType())) {
            String operator = binaryExpressionTree.operatorToken().text();
            String replacement = REPLACEMENTS.get(operator);
            String sideEffectWarning = "";
            if (NonShortCircuitLogicCheck.mayHaveSideEffect((Tree)binaryExpressionTree.rightOperand())) {
                sideEffectWarning = " and extract the right operand to a variable if it should always be evaluated";
            }
            this.reportIssue((Tree)binaryExpressionTree.operatorToken(), "Correct this \"" + operator + "\" to \"" + replacement + "\"" + sideEffectWarning + ".");
        }
    }

    private static boolean isBoolean(Type type) {
        return type.is("boolean") || type.is("java.lang.Boolean");
    }

    private static boolean mayHaveSideEffect(Tree tree) {
        MethodInvocationFinder methodInvocationFinder = new MethodInvocationFinder();
        tree.accept((TreeVisitor)methodInvocationFinder);
        return methodInvocationFinder.found;
    }

    private static class MethodInvocationFinder
    extends BaseTreeVisitor {
        boolean found = false;

        private MethodInvocationFinder() {
        }

        public void visitMethodInvocation(MethodInvocationTree tree) {
            this.found = true;
        }
    }
}

