/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.java.matcher.MethodMatcher;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S4508")
public class ObjectDeserializationCheck
extends AbstractMethodDetection {
    private static final String OBJECT_INPUT_STREAM = "java.io.ObjectInputStream";
    private static final String MESSAGE = "Make sure deserializing objects is safe here.";

    @Override
    protected List<MethodMatcher> getMethodInvocationMatchers() {
        return ImmutableList.of((Object)MethodMatcher.create().typeDefinition(OBJECT_INPUT_STREAM).name("readObject").withoutParameter(), (Object)MethodMatcher.create().typeDefinition(OBJECT_INPUT_STREAM).name("readUnshared").withoutParameter());
    }

    @Override
    protected void onMethodInvocationFound(MethodInvocationTree mit) {
        this.reportIssue((Tree)mit, MESSAGE);
    }
}

