/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.PrimitiveTypeTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TypeTree;

@Rule(key="S1175")
public class ObjectFinalizeOverloadedCheck
extends IssuableSubscriptionVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.METHOD);
    }

    public void visitNode(Tree tree) {
        MethodTree methodTree = (MethodTree)tree;
        if (ObjectFinalizeOverloadedCheck.isFinalizeOverload(methodTree)) {
            this.reportIssue((Tree)methodTree.simpleName(), "Rename this method to avoid any possible confusion with Object.finalize().");
        }
    }

    private static boolean isFinalizeOverload(MethodTree methodTree) {
        return ObjectFinalizeOverloadedCheck.isNamedFinalize(methodTree) && (!ObjectFinalizeOverloadedCheck.hasNoParameter(methodTree) || !ObjectFinalizeOverloadedCheck.isVoid(methodTree));
    }

    private static boolean isNamedFinalize(MethodTree methodTree) {
        return "finalize".equals(methodTree.simpleName().name());
    }

    private static boolean hasNoParameter(MethodTree methodTree) {
        return methodTree.parameters().isEmpty();
    }

    private static boolean isVoid(MethodTree methodTree) {
        TypeTree typeTree = methodTree.returnType();
        return typeTree.is(new Tree.Kind[]{Tree.Kind.PRIMITIVE_TYPE}) && "void".equals(((PrimitiveTypeTree)typeTree).keyword().text());
    }
}

