/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.math.BigInteger;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.java.matcher.MethodMatcher;
import org.sonar.java.model.LiteralUtils;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.LiteralTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S2129")
public class StringPrimitiveConstructorCheck
extends AbstractMethodDetection {
    private static final String STRING = "java.lang.String";
    private static final String INIT = "<init>";
    private static final BigInteger MIN_BIG_INTEGER_VALUE = BigInteger.valueOf(Long.MIN_VALUE);
    private static final BigInteger MAX_BIG_INTEGER_VALUE = BigInteger.valueOf(Long.MAX_VALUE);

    @Override
    protected List<MethodMatcher> getMethodInvocationMatchers() {
        return ImmutableList.of((Object)MethodMatcher.create().typeDefinition(STRING).name(INIT).withoutParameter(), (Object)MethodMatcher.create().typeDefinition(STRING).name(INIT).addParameter(STRING), (Object)MethodMatcher.create().typeDefinition("java.lang.Byte").name(INIT).addParameter("byte"), (Object)MethodMatcher.create().typeDefinition("java.lang.Character").name(INIT).addParameter("char"), (Object)MethodMatcher.create().typeDefinition("java.lang.Short").name(INIT).addParameter("short"), (Object)MethodMatcher.create().typeDefinition("java.lang.Integer").name(INIT).addParameter("int"), (Object)MethodMatcher.create().typeDefinition("java.lang.Long").name(INIT).addParameter("long"), (Object)MethodMatcher.create().typeDefinition("java.lang.Float").name(INIT).addParameter("float"), (Object)MethodMatcher.create().typeDefinition("java.lang.Double").name(INIT).addParameter("double"), (Object)MethodMatcher.create().typeDefinition("java.lang.Boolean").name(INIT).addParameter("boolean"), (Object)MethodMatcher.create().typeDefinition("java.math.BigInteger").name(INIT).addParameter(STRING), (Object)MethodMatcher.create().typeDefinition("java.math.BigDecimal").name(INIT).addParameter("double"), (Object[])new MethodMatcher[0]);
    }

    @Override
    protected void onConstructorFound(NewClassTree newClassTree) {
        if (StringPrimitiveConstructorCheck.isBigIntegerPotentiallyBiggerThanLong(newClassTree)) {
            return;
        }
        this.reportIssue((Tree)newClassTree.identifier(), "Remove this \"" + newClassTree.symbolType().name() + "\" constructor");
    }

    private static boolean isBigIntegerPotentiallyBiggerThanLong(NewClassTree newClassTree) {
        if (!newClassTree.symbolType().is("java.math.BigInteger")) {
            return false;
        }
        ExpressionTree argument = (ExpressionTree)newClassTree.arguments().get(0);
        if (!argument.is(new Tree.Kind[]{Tree.Kind.STRING_LITERAL})) {
            return true;
        }
        try {
            BigInteger value = new BigInteger(LiteralUtils.trimQuotes((String)((LiteralTree)argument).value()));
            return value.compareTo(MIN_BIG_INTEGER_VALUE) < 0 || value.compareTo(MAX_BIG_INTEGER_VALUE) > 0;
        }
        catch (NumberFormatException e) {
            return true;
        }
    }
}

