/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.model.ModifiersUtils;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.BlockTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Modifier;
import org.sonar.plugins.java.api.tree.ModifiersTree;
import org.sonar.plugins.java.api.tree.StatementTree;
import org.sonar.plugins.java.api.tree.SynchronizedStatementTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S2886")
public class SyncGetterAndSetterCheck
extends IssuableSubscriptionVisitor {
    private static final GetSetPredicate SETTER = new GetSetPredicate(){

        @Override
        public String getStartName() {
            return "set";
        }

        @Override
        public boolean apply(MethodTree methodTree) {
            return methodTree.simpleName().name().startsWith(this.getStartName()) && methodTree.parameters().size() == 1 && methodTree.returnType().symbolType().is("void");
        }
    };
    private static final GetSetPredicate GETTER = new GetSetPredicate(){

        @Override
        public String getStartName() {
            return "get";
        }

        @Override
        public boolean apply(MethodTree methodTree) {
            return methodTree.simpleName().name().startsWith(this.getStartName()) && methodTree.parameters().isEmpty() && !methodTree.returnType().symbolType().is("void");
        }
    };
    private static final GetSetPredicate GETTER_BOOLEAN = new GetSetPredicate(){

        @Override
        public String getStartName() {
            return "is";
        }

        @Override
        public boolean apply(MethodTree methodTree) {
            return methodTree.simpleName().name().startsWith(this.getStartName()) && methodTree.parameters().isEmpty() && !methodTree.returnType().symbolType().is("void");
        }
    };

    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.METHOD);
    }

    public void visitNode(Tree tree) {
        if (!this.hasSemantic()) {
            return;
        }
        MethodTree methodTree = (MethodTree)tree;
        this.checkMethodTree(methodTree, GETTER, SETTER);
        this.checkMethodTree(methodTree, GETTER_BOOLEAN, SETTER);
        this.checkMethodTree(methodTree, SETTER, GETTER);
        this.checkMethodTree(methodTree, SETTER, GETTER_BOOLEAN);
    }

    private void checkMethodTree(MethodTree methodTree, GetSetPredicate ownPredicate, GetSetPredicate pairPredicate) {
        if (SyncGetterAndSetterCheck.isSynchronized(methodTree) && ownPredicate.apply(methodTree)) {
            Symbol.TypeSymbol owner = (Symbol.TypeSymbol)methodTree.symbol().owner();
            Collection pairedMethods = owner.lookupSymbols(pairPredicate.getStartName() + methodTree.symbol().name().substring(ownPredicate.getStartName().length()));
            pairedMethods.stream().filter(Symbol::isMethodSymbol).map(symbol -> (MethodTree)symbol.declaration()).filter(pairMethod -> pairPredicate.apply((MethodTree)pairMethod) && !SyncGetterAndSetterCheck.isSynchronized(pairMethod)).forEach(pairMethod -> this.reportIssue((Tree)pairMethod.simpleName(), "Synchronize this method to match the synchronization on \"" + methodTree.simpleName().name() + "\".", Lists.newArrayList((Object[])new JavaFileScannerContext.Location[]{new JavaFileScannerContext.Location("", (Tree)methodTree.simpleName())}), null));
        }
    }

    private static boolean isSynchronized(MethodTree methodTree) {
        return ModifiersUtils.hasModifier((ModifiersTree)methodTree.modifiers(), (Modifier)Modifier.SYNCHRONIZED) || SyncGetterAndSetterCheck.hasSingleSyncStatement(methodTree);
    }

    private static boolean hasSingleSyncStatement(MethodTree methodTree) {
        BlockTree blockTree = methodTree.block();
        if (blockTree != null && blockTree.body().size() == 1 && ((StatementTree)blockTree.body().get(0)).is(new Tree.Kind[]{Tree.Kind.SYNCHRONIZED_STATEMENT})) {
            SynchronizedStatementTree sync = (SynchronizedStatementTree)blockTree.body().get(0);
            return sync.expression().is(new Tree.Kind[]{Tree.Kind.IDENTIFIER}) && "this".equals(((IdentifierTree)sync.expression()).name());
        }
        return false;
    }

    private static interface GetSetPredicate {
        public String getStartName();

        public boolean apply(MethodTree var1);
    }
}

