/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Collections;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.JavaVersionAwareVisitor;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.java.matcher.MethodMatcher;
import org.sonar.plugins.java.api.JavaVersion;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S4065")
public class ThreadLocalWithInitialCheck
extends AbstractMethodDetection
implements JavaVersionAwareVisitor {
    private static final MethodMatcher THREADLOCAL_CONSTRUCTOR = MethodMatcher.create().typeDefinition("java.lang.ThreadLocal").name("<init>").withoutParameter();

    @Override
    protected List<MethodMatcher> getMethodInvocationMatchers() {
        return Collections.singletonList(THREADLOCAL_CONSTRUCTOR);
    }

    @Override
    protected void onConstructorFound(NewClassTree newClassTree) {
        ClassTree classTree = newClassTree.classBody();
        if (classTree == null) {
            return;
        }
        List members = classTree.members();
        if (members.size() != 1) {
            return;
        }
        members.stream().filter(tree -> tree.is(new Tree.Kind[]{Tree.Kind.METHOD})).map(t -> (MethodTree)t).filter(t -> "initialValue".equals(t.simpleName().name())).filter(t -> t.parameters().isEmpty()).findFirst().ifPresent(t -> this.reportIssue((Tree)newClassTree.identifier(), "Replace this anonymous class with a call to \"ThreadLocal.withInitial\"." + this.context.getJavaVersion().java8CompatibilityMessage()));
    }

    public boolean isCompatibleWithJavaVersion(JavaVersion version) {
        return version.isJava8Compatible();
    }
}

