/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.checks.AbstractInSynchronizeChecker;
import org.sonar.java.matcher.MethodMatcher;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S2273")
public class WaitInSynchronizeCheck
extends AbstractInSynchronizeChecker {
    @Override
    protected void onMethodInvocationFound(MethodInvocationTree mit) {
        if (!this.isInSyncBlock()) {
            IdentifierTree methodName = ExpressionUtils.methodName((MethodInvocationTree)mit);
            ExpressionTree methodSelect = mit.methodSelect();
            String lockName = methodSelect.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT}) ? ((MemberSelectExpressionTree)methodSelect).expression().symbolType().name() : "this";
            this.reportIssue((Tree)methodName, "Move this call to \"" + methodName + "()\" into a synchronized block to be sure the monitor on \"" + lockName + "\" is held.");
        }
    }

    @Override
    protected List<MethodMatcher> getMethodInvocationMatchers() {
        return ImmutableList.builder().add((Object)MethodMatcher.create().name("wait").withoutParameter()).add((Object)MethodMatcher.create().name("wait").addParameter("long")).add((Object)MethodMatcher.create().name("wait").addParameter("long").addParameter("int")).add((Object)MethodMatcher.create().name("notify").withoutParameter()).add((Object)MethodMatcher.create().name("notifyAll").withoutParameter()).build();
    }
}

