/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.Deque;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.java.matcher.MethodMatcher;
import org.sonar.java.matcher.NameCriteria;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.ForStatementTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S2274")
public class WaitInWhileLoopCheck
extends AbstractMethodDetection {
    private Deque<Boolean> inWhileLoop = Lists.newLinkedList();

    public void scanFile(JavaFileScannerContext context) {
        this.inWhileLoop.push(false);
        super.scanFile(context);
        this.inWhileLoop.clear();
    }

    @Override
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.METHOD_INVOCATION, (Object)Tree.Kind.WHILE_STATEMENT, (Object)Tree.Kind.DO_STATEMENT, (Object)Tree.Kind.FOR_STATEMENT);
    }

    @Override
    public void visitNode(Tree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION})) {
            super.visitNode(tree);
        } else if (tree.is(new Tree.Kind[]{Tree.Kind.FOR_STATEMENT})) {
            ForStatementTree fst = (ForStatementTree)tree;
            this.inWhileLoop.push(fst.initializer().isEmpty() && fst.condition() == null && fst.update().isEmpty());
        } else {
            this.inWhileLoop.push(true);
        }
    }

    public void leaveNode(Tree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.WHILE_STATEMENT, Tree.Kind.DO_STATEMENT, Tree.Kind.FOR_STATEMENT})) {
            this.inWhileLoop.pop();
        }
    }

    @Override
    protected void onMethodInvocationFound(MethodInvocationTree mit) {
        if (!this.inWhileLoop.peek().booleanValue()) {
            IdentifierTree identifierTree = ExpressionUtils.methodName((MethodInvocationTree)mit);
            this.reportIssue((Tree)identifierTree, "Remove this call to \"" + identifierTree.name() + "\" or move it into a \"while\" loop.");
        }
    }

    @Override
    protected List<MethodMatcher> getMethodInvocationMatchers() {
        return ImmutableList.of((Object)MethodMatcher.create().name("wait").withoutParameter(), (Object)MethodMatcher.create().name("wait").addParameter("long"), (Object)MethodMatcher.create().name("wait").addParameter("long").addParameter("int"), (Object)MethodMatcher.create().typeDefinition("java.util.concurrent.locks.Condition").name(NameCriteria.startsWith((String)"await")).withAnyParameters());
    }
}

