/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.model.ModifiersUtils;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Modifier;
import org.sonar.plugins.java.api.tree.ModifiersTree;
import org.sonar.plugins.java.api.tree.ParameterizedTypeTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;
import org.sonar.plugins.java.api.tree.WildcardTree;

@Rule(key="S1452")
public class WildcardReturnParameterTypeCheck
extends IssuableSubscriptionVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.METHOD);
    }

    public void visitNode(Tree tree) {
        MethodTree methodTree = (MethodTree)tree;
        if (!WildcardReturnParameterTypeCheck.isPrivate(methodTree) && !WildcardReturnParameterTypeCheck.isOverriding(methodTree)) {
            methodTree.returnType().accept((TreeVisitor)new CheckWildcard());
        }
    }

    private static boolean isPrivate(MethodTree methodTree) {
        return ModifiersUtils.hasModifier((ModifiersTree)methodTree.modifiers(), (Modifier)Modifier.PRIVATE);
    }

    private static boolean isOverriding(MethodTree tree) {
        return Boolean.TRUE.equals(tree.isOverriding());
    }

    private class CheckWildcard
    extends BaseTreeVisitor {
        private boolean classType = false;

        private CheckWildcard() {
        }

        public void visitParameterizedType(ParameterizedTypeTree tree) {
            this.classType = tree.type().symbolType().is("java.lang.Class");
            super.visitParameterizedType(tree);
            this.classType = false;
        }

        public void visitWildcard(WildcardTree tree) {
            if (!this.classType) {
                WildcardReturnParameterTypeCheck.this.reportIssue((Tree)tree.queryToken(), "Remove usage of generic wildcard type.");
            }
        }
    }
}

