/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.helpers;

import javax.annotation.CheckForNull;
import org.sonar.java.model.LiteralUtils;
import org.sonar.java.resolve.JavaSymbol;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.BinaryExpressionTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.LiteralTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.ParenthesizedTree;
import org.sonar.plugins.java.api.tree.Tree;

public class ConstantUtils {
    private ConstantUtils() {
    }

    @CheckForNull
    public static String resolveAsStringConstant(ExpressionTree tree) {
        Object constant = ConstantUtils.resolveAsConstant(tree);
        return constant instanceof String ? (String)constant : null;
    }

    @CheckForNull
    public static Integer resolveAsIntConstant(ExpressionTree tree) {
        Object constant = ConstantUtils.resolveAsConstant(tree);
        return constant instanceof Integer ? (Integer)constant : null;
    }

    @CheckForNull
    public static Long resolveAsLongConstant(ExpressionTree tree) {
        Object constant = ConstantUtils.resolveAsConstant(tree);
        if (constant instanceof Long) {
            return (Long)constant;
        }
        if (constant instanceof Integer) {
            return ((Integer)constant).longValue();
        }
        return null;
    }

    @CheckForNull
    public static Boolean resolveAsBooleanConstant(ExpressionTree tree) {
        Object constant = ConstantUtils.resolveAsConstant(tree);
        return constant instanceof Boolean ? (Boolean)constant : null;
    }

    @CheckForNull
    public static Object resolveAsConstant(ExpressionTree tree) {
        ExpressionTree expression = tree;
        while (expression.is(new Tree.Kind[]{Tree.Kind.PARENTHESIZED_EXPRESSION})) {
            expression = ((ParenthesizedTree)expression).expression();
        }
        if (expression.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
            expression = ((MemberSelectExpressionTree)expression).identifier();
        }
        if (expression.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
            return ConstantUtils.resolveIdentifier((IdentifierTree)expression);
        }
        if (expression.is(new Tree.Kind[]{Tree.Kind.BOOLEAN_LITERAL})) {
            return Boolean.parseBoolean(((LiteralTree)expression).value());
        }
        if (expression.is(new Tree.Kind[]{Tree.Kind.STRING_LITERAL})) {
            return LiteralUtils.trimQuotes((String)((LiteralTree)expression).value());
        }
        if (tree.is(new Tree.Kind[]{Tree.Kind.INT_LITERAL})) {
            return LiteralUtils.intLiteralValue((ExpressionTree)tree);
        }
        if (tree.is(new Tree.Kind[]{Tree.Kind.LONG_LITERAL})) {
            return LiteralUtils.longLiteralValue((ExpressionTree)tree);
        }
        if (expression.is(new Tree.Kind[]{Tree.Kind.PLUS})) {
            return ConstantUtils.resolvePlus((BinaryExpressionTree)expression);
        }
        return null;
    }

    @CheckForNull
    private static Object resolveIdentifier(IdentifierTree tree) {
        JavaSymbol.TypeJavaSymbol ownerType;
        Symbol symbol = tree.symbol();
        if (!symbol.isVariableSymbol()) {
            return null;
        }
        JavaSymbol.VariableJavaSymbol javaSymbol = (JavaSymbol.VariableJavaSymbol)symbol;
        JavaSymbol owner = javaSymbol.owner();
        if (owner.isTypeSymbol() && "java.lang.Boolean".equals((ownerType = (JavaSymbol.TypeJavaSymbol)owner).getFullyQualifiedName())) {
            if ("TRUE".equals(javaSymbol.getName())) {
                return Boolean.TRUE;
            }
            if ("FALSE".equals(javaSymbol.getName())) {
                return Boolean.FALSE;
            }
        }
        return javaSymbol.constantValue().orElse(null);
    }

    @CheckForNull
    private static Object resolvePlus(BinaryExpressionTree binaryExpression) {
        Object left = ConstantUtils.resolveAsConstant(binaryExpression.leftOperand());
        Object right = ConstantUtils.resolveAsConstant(binaryExpression.rightOperand());
        if (left == null || right == null) {
            return null;
        }
        if (left instanceof String) {
            return (String)left + right;
        }
        if (right instanceof String) {
            return left + (String)right;
        }
        if (left instanceof Long && right instanceof Long) {
            return (Long)left + (Long)right;
        }
        if (left instanceof Long && right instanceof Integer) {
            return (Long)left + (long)((Integer)right).intValue();
        }
        if (left instanceof Integer && right instanceof Long) {
            return (long)((Integer)left).intValue() + (Long)right;
        }
        if (left instanceof Integer && right instanceof Integer) {
            return (Integer)left + (Integer)right;
        }
        return null;
    }
}

