/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.helpers;

import java.util.function.Function;
import javax.annotation.CheckForNull;
import org.sonar.java.checks.helpers.ReassignmentFinder;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.Tree;

public class IdentifierUtils {
    private IdentifierUtils() {
    }

    @CheckForNull
    public static <T> T getValue(ExpressionTree expression, Function<ExpressionTree, T> resolver) {
        Object value = resolver.apply(expression);
        if (value == null && expression.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
            ExpressionTree last = ReassignmentFinder.getClosestReassignmentOrDeclarationExpression((Tree)expression, ((IdentifierTree)expression).symbol());
            value = last == null || !IdentifierUtils.isStrictAssignmentOrDeclaration(last) || last == expression ? null : IdentifierUtils.getValue(last, resolver);
        }
        return value;
    }

    private static boolean isStrictAssignmentOrDeclaration(ExpressionTree expression) {
        if (expression.parent() instanceof AssignmentExpressionTree) {
            return expression.parent().is(new Tree.Kind[]{Tree.Kind.ASSIGNMENT});
        }
        return true;
    }
}

