/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.security;

import java.util.Collections;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.checks.helpers.ConstantUtils;
import org.sonar.java.checks.helpers.JavaPropertiesHelper;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.java.matcher.MethodMatcher;
import org.sonar.java.matcher.TypeCriteria;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S4432")
public class AESAlgorithmCheck
extends AbstractMethodDetection {
    @Override
    protected List<MethodMatcher> getMethodInvocationMatchers() {
        return Collections.singletonList(MethodMatcher.create().typeDefinition(TypeCriteria.is((String)"javax.crypto.Cipher")).name("getInstance").withAnyParameters());
    }

    @Override
    protected void onMethodInvocationFound(MethodInvocationTree mit) {
        if (mit.arguments().isEmpty()) {
            return;
        }
        ExpressionTree firstArgument = (ExpressionTree)mit.arguments().get(0);
        ExpressionTree defaultPropertyValue = JavaPropertiesHelper.retrievedPropertyDefaultValue(firstArgument);
        ExpressionTree algorithmTree = defaultPropertyValue == null ? firstArgument : defaultPropertyValue;
        String algorithmName = ConstantUtils.resolveAsStringConstant(algorithmTree);
        if (algorithmName != null && AESAlgorithmCheck.isInsecureAESAlgorithm(algorithmName)) {
            this.reportIssue((Tree)firstArgument, "Use Galois/Counter Mode (GCM/NoPadding) instead.");
        }
    }

    private static boolean isInsecureAESAlgorithm(String algorithmName) {
        return algorithmName.startsWith("AES/ECB/") || "AES/CBC/PKCS5Padding".equals(algorithmName);
    }
}

