/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.security;

import java.util.Collections;
import java.util.List;
import javax.annotation.CheckForNull;
import org.sonar.check.Rule;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.java.matcher.MethodMatcher;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;

@Rule(key="S3329")
public class CipherBlockChainingCheck
extends AbstractMethodDetection {
    @Override
    protected List<MethodMatcher> getMethodInvocationMatchers() {
        return Collections.singletonList(MethodMatcher.create().typeDefinition("javax.crypto.spec.IvParameterSpec").name("<init>").withAnyParameters());
    }

    @Override
    protected void onConstructorFound(NewClassTree newClassTree) {
        MethodTree mTree = CipherBlockChainingCheck.findEnclosingMethod((Tree)newClassTree);
        if (mTree != null) {
            MethodInvocationVisitor mitVisit = new MethodInvocationVisitor(newClassTree);
            mTree.accept((TreeVisitor)mitVisit);
            if (!mitVisit.secureRandomFound) {
                this.reportIssue((Tree)newClassTree, "Use a dynamically-generated, random IV.");
            }
        }
    }

    private static MethodTree findEnclosingMethod(Tree tree) {
        while (!tree.is(new Tree.Kind[]{Tree.Kind.CLASS, Tree.Kind.METHOD})) {
            tree = tree.parent();
        }
        if (tree.is(new Tree.Kind[]{Tree.Kind.CLASS})) {
            return null;
        }
        return (MethodTree)tree;
    }

    private static class MethodInvocationVisitor
    extends BaseTreeVisitor {
        private boolean secureRandomFound = false;
        private NewClassTree ivParameterSpecInstantiation = null;
        private static final MethodMatcher SECURE_RANDOM_NEXT_BYTES = MethodMatcher.create().typeDefinition("java.security.SecureRandom").name("nextBytes").withAnyParameters();

        public MethodInvocationVisitor(NewClassTree newClassTree) {
            this.ivParameterSpecInstantiation = newClassTree;
        }

        public void visitMethodInvocation(MethodInvocationTree methodInvocation) {
            Symbol initVector;
            if (SECURE_RANDOM_NEXT_BYTES.matches(methodInvocation) && (initVector = MethodInvocationVisitor.symbol((ExpressionTree)this.ivParameterSpecInstantiation.arguments().get(0))) != null && initVector.equals(MethodInvocationVisitor.symbol((ExpressionTree)methodInvocation.arguments().get(0)))) {
                this.secureRandomFound = true;
            }
            super.visitMethodInvocation(methodInvocation);
        }

        @CheckForNull
        private static Symbol symbol(ExpressionTree expression) {
            Symbol symbol = null;
            if (expression.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
                symbol = ((IdentifierTree)expression).symbol();
            } else if (expression.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
                symbol = ((MemberSelectExpressionTree)expression).identifier().symbol();
            }
            return symbol;
        }
    }
}

