/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.security;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.java.matcher.MethodMatcher;
import org.sonar.java.matcher.TypeCriteria;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S4721")
public class ExecCallCheck
extends AbstractMethodDetection {
    private static final String MESSAGE = "Make sure that executing this OS command is safe here.";
    private static final String PROCESS_BUILDER = "java.lang.ProcessBuilder";

    @Override
    protected List<MethodMatcher> getMethodInvocationMatchers() {
        return ImmutableList.of((Object)MethodMatcher.create().typeDefinition("java.lang.Runtime").name("exec").withAnyParameters(), (Object)MethodMatcher.create().typeDefinition(TypeCriteria.subtypeOf((String)"org.apache.commons.exec.Executor")).name("execute").withAnyParameters(), (Object)MethodMatcher.create().typeDefinition(PROCESS_BUILDER).name("command").withAnyParameters(), (Object)MethodMatcher.create().typeDefinition(TypeCriteria.subtypeOf((String)PROCESS_BUILDER)).name("<init>").withAnyParameters());
    }

    @Override
    protected void onMethodInvocationFound(MethodInvocationTree mit) {
        if (!mit.symbol().name().equals("command") || !mit.arguments().isEmpty()) {
            this.reportIssue((Tree)mit, MESSAGE);
        }
    }

    @Override
    protected void onConstructorFound(NewClassTree newClassTree) {
        if (!newClassTree.arguments().isEmpty()) {
            this.reportIssue((Tree)newClassTree, MESSAGE);
        }
    }
}

