/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.spring;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.sonar.check.Rule;
import org.sonar.java.matcher.MethodMatcher;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.SymbolMetadata;
import org.sonar.plugins.java.api.tree.AnnotationTree;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;

@Rule(key="S3753")
public class ControllerWithSessionAttributesCheck
extends IssuableSubscriptionVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.CLASS);
    }

    public void visitNode(Tree tree) {
        if (!this.hasSemantic()) {
            return;
        }
        ClassTree classTree = (ClassTree)tree;
        SymbolMetadata classMetadata = classTree.symbol().metadata();
        Optional<AnnotationTree> sessionAttributesAnnotation = classTree.modifiers().annotations().stream().filter(a -> a.annotationType().symbolType().is("org.springframework.web.bind.annotation.SessionAttributes")).findFirst();
        if (sessionAttributesAnnotation.isPresent() && classMetadata.isAnnotatedWith("org.springframework.stereotype.Controller")) {
            MethodInvocationVisitor methodInvocationVisitor = new MethodInvocationVisitor();
            classTree.accept((TreeVisitor)methodInvocationVisitor);
            if (!methodInvocationVisitor.setCompleteIsCalled) {
                this.reportIssue((Tree)sessionAttributesAnnotation.get().annotationType(), "Add a call to \"setComplete()\" on the SessionStatus object in a \"@RequestMapping\" method.");
            }
        }
    }

    private static class MethodInvocationVisitor
    extends BaseTreeVisitor {
        private static final MethodMatcher SET_COMPLETE = MethodMatcher.create().typeDefinition("org.springframework.web.bind.support.SessionStatus").name("setComplete").withAnyParameters();
        boolean setCompleteIsCalled;

        private MethodInvocationVisitor() {
        }

        public void visitMethodInvocation(MethodInvocationTree methodInvocationTree) {
            if (SET_COMPLETE.matches(methodInvocationTree)) {
                this.setCompleteIsCalled = true;
            }
        }
    }
}

