/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.spring;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.SymbolMetadata;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S4684")
public class PersistentEntityUsedAsRequestParameterCheck
extends IssuableSubscriptionVisitor {
    private static final List<String> REQUEST_ANNOTATIONS = Arrays.asList("org.springframework.web.bind.annotation.RequestMapping", "org.springframework.web.bind.annotation.GetMapping", "org.springframework.web.bind.annotation.PostMapping", "org.springframework.web.bind.annotation.PutMapping", "org.springframework.web.bind.annotation.DeleteMapping", "org.springframework.web.bind.annotation.PatchMapping");
    private static final List<String> ENTITY_ANNOTATIONS = Arrays.asList("javax.persistence.Entity", "org.springframework.data.mongodb.core.mapping.Document", "org.springframework.data.elasticsearch.annotations.Document");

    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.METHOD);
    }

    public void visitNode(Tree tree) {
        if (!this.hasSemantic()) {
            return;
        }
        MethodTree methodTree = (MethodTree)tree;
        Symbol.MethodSymbol methodSymbol = methodTree.symbol();
        if (PersistentEntityUsedAsRequestParameterCheck.isRequestMappingAnnotated(methodSymbol)) {
            methodTree.parameters().stream().filter(PersistentEntityUsedAsRequestParameterCheck::isPersistentEntity).forEach(p -> this.reportIssue((Tree)p.simpleName(), "Replace this persistent entity with a simple POJO or DTO object."));
        }
    }

    private static boolean isRequestMappingAnnotated(Symbol.MethodSymbol methodSymbol) {
        return REQUEST_ANNOTATIONS.stream().anyMatch(arg_0 -> ((SymbolMetadata)methodSymbol.metadata()).isAnnotatedWith(arg_0));
    }

    private static boolean isPersistentEntity(VariableTree variableTree) {
        return ENTITY_ANNOTATIONS.stream().anyMatch(arg_0 -> ((SymbolMetadata)variableTree.type().symbolType().symbol().metadata()).isAnnotatedWith(arg_0));
    }
}

