/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.spring;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.SymbolMetadata;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.LiteralTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S3750")
public class SpringComponentWithWrongScopeCheck
extends IssuableSubscriptionVisitor {
    private static final String SCOPE_ANNOTATION_FQN = "org.springframework.context.annotation.Scope";

    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.CLASS);
    }

    public void visitNode(Tree tree) {
        ClassTree clazzTree = (ClassTree)tree;
        SymbolMetadata clazzMeta = clazzTree.symbol().metadata();
        if (SpringComponentWithWrongScopeCheck.isSpringComponent(clazzMeta) && clazzMeta.isAnnotatedWith(SCOPE_ANNOTATION_FQN) && !SpringComponentWithWrongScopeCheck.isScopeSingleton(clazzMeta)) {
            this.checkScopeAnnotation(clazzTree);
        }
    }

    private static boolean isSpringComponent(SymbolMetadata clazzMeta) {
        return clazzMeta.isAnnotatedWith("org.springframework.stereotype.Controller") || clazzMeta.isAnnotatedWith("org.springframework.stereotype.Service") || clazzMeta.isAnnotatedWith("org.springframework.stereotype.Repository");
    }

    private static boolean isScopeSingleton(SymbolMetadata clazzMeta) {
        List values = clazzMeta.valuesForAnnotation(SCOPE_ANNOTATION_FQN);
        for (SymbolMetadata.AnnotationValue annotationValue : values) {
            if (!"value".equals(annotationValue.name()) && !"scopeName".equals(annotationValue.name()) || !(annotationValue.value() instanceof LiteralTree) || "\"singleton\"".equals(((LiteralTree)annotationValue.value()).value())) continue;
            return false;
        }
        return true;
    }

    private void checkScopeAnnotation(ClassTree tree) {
        tree.modifiers().annotations().stream().filter(a -> a.annotationType().symbolType().fullyQualifiedName().equals(SCOPE_ANNOTATION_FQN)).forEach(a -> this.reportIssue((Tree)a, "Remove this \"@Scope\" annotation."));
    }
}

