/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.xml.spring;

import com.google.common.collect.Iterables;
import java.util.stream.IntStream;
import java.util.stream.StreamSupport;
import javax.xml.xpath.XPathExpression;
import org.sonar.check.Rule;
import org.sonar.java.xml.XPathXmlCheck;
import org.sonar.java.xml.XmlCheckContext;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

@Rule(key="S3439")
public class DefaultMessageListenerContainerCheck
extends XPathXmlCheck {
    private XPathExpression defaultMessageListenerContainerBeanExpression;
    private XPathExpression acceptMessageWhileStoppingPropertyExpression;
    private XPathExpression sessionTransactedPropertyExpression;
    private XPathExpression valueExpression;

    public void precompileXPathExpressions(XmlCheckContext context) {
        this.defaultMessageListenerContainerBeanExpression = context.compile("beans/bean[@class='org.springframework.jms.listener.DefaultMessageListenerContainer']");
        this.acceptMessageWhileStoppingPropertyExpression = context.compile("property[@name='acceptMessagesWhileStopping']");
        this.sessionTransactedPropertyExpression = context.compile("property[@name='sessionTransacted']");
        this.valueExpression = context.compile("value[text()='true']");
    }

    public void scanFileWithXPathExpressions(XmlCheckContext context) {
        StreamSupport.stream(context.evaluateOnDocument(this.defaultMessageListenerContainerBeanExpression).spliterator(), false).filter(bean -> !this.hasAcceptMessagePropertyEnabled(context, (Node)bean) && this.hasSessionTransactedDisabled(context, (Node)bean)).forEach(bean -> this.reportIssue((Node)bean, "Enable \"acceptMessagesWhileStopping\"."));
    }

    private boolean hasAcceptMessagePropertyEnabled(XmlCheckContext context, Node bean) {
        return DefaultMessageListenerContainerCheck.hasAttributeValue(bean, "acceptMessagesWhileStopping") || this.hasPropertyAsChild(context, bean, this.acceptMessageWhileStoppingPropertyExpression);
    }

    private boolean hasSessionTransactedDisabled(XmlCheckContext context, Node bean) {
        return !DefaultMessageListenerContainerCheck.hasAttributeValue(bean, "sessionTransacted") && !this.hasPropertyAsChild(context, bean, this.sessionTransactedPropertyExpression);
    }

    private static boolean hasAttributeValue(Node bean, String attributeName) {
        NamedNodeMap attributes = bean.getAttributes();
        return IntStream.range(0, attributes.getLength()).mapToObj(attributes::item).anyMatch(attribute -> attribute.getNodeName().endsWith(attributeName) && "true".equals(attribute.getNodeValue()));
    }

    private boolean hasPropertyAsChild(XmlCheckContext context, Node bean, XPathExpression expression) {
        return StreamSupport.stream(context.evaluate(expression, bean).spliterator(), false).anyMatch(property -> DefaultMessageListenerContainerCheck.hasAttributeValue(property, "value") || !Iterables.isEmpty((Iterable)context.evaluate(this.valueExpression, property)));
    }
}

