/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.xml.web;

import com.google.common.collect.Iterables;
import javax.xml.xpath.XPathExpression;
import org.sonar.check.Rule;
import org.sonar.java.checks.xml.web.WebXmlCheckTemplate;
import org.sonar.java.xml.XmlCheckContext;

@Rule(key="S3369")
public class SecurityConstraintsInWebXmlCheck
extends WebXmlCheckTemplate {
    private XPathExpression securityConstraintExpression;

    public void precompileXPathExpressions(XmlCheckContext context) {
        this.securityConstraintExpression = context.compile("web-app/security-constraint");
    }

    @Override
    public void scanWebXml(XmlCheckContext context) {
        if (this.hasNoSecurityConstraint(context)) {
            this.reportIssueOnFile("Add \"security-constraint\" elements to this descriptor.");
        }
    }

    private boolean hasNoSecurityConstraint(XmlCheckContext context) {
        return Iterables.isEmpty((Iterable)context.evaluateOnDocument(this.securityConstraintExpression));
    }
}

