/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.xml.web;

import java.util.HashSet;
import java.util.Set;
import javax.xml.xpath.XPathExpression;
import org.sonar.check.Rule;
import org.sonar.java.checks.xml.web.WebXmlCheckTemplate;
import org.sonar.java.xml.XmlCheckContext;
import org.w3c.dom.Node;

@Rule(key="S3355")
public class ValidationFiltersCheck
extends WebXmlCheckTemplate {
    private XPathExpression filterNamesFromFilterExpression;
    private XPathExpression filterNamesFromFilterMappingExpression;

    public void precompileXPathExpressions(XmlCheckContext context) {
        this.filterNamesFromFilterExpression = context.compile("web-app/filter/filter-name");
        this.filterNamesFromFilterMappingExpression = context.compile("web-app/filter-mapping/filter-name");
    }

    @Override
    public void scanWebXml(XmlCheckContext context) {
        Iterable filtersDefinedInFilters = context.evaluateOnDocument(this.filterNamesFromFilterExpression);
        Iterable filtersUsedInMapping = context.evaluateOnDocument(this.filterNamesFromFilterMappingExpression);
        Set<String> filtersInMapping = ValidationFiltersCheck.getFilterNames(filtersUsedInMapping);
        for (Node node : filtersDefinedInFilters) {
            String filterName = ValidationFiltersCheck.getStringValue(node);
            if (filtersInMapping.contains(filterName)) continue;
            this.reportIssue(node, "\"" + filterName + "\" should have a mapping.");
        }
    }

    private static Set<String> getFilterNames(Iterable<Node> nodes) {
        HashSet<String> nodeByFilterName = new HashSet<String>();
        for (Node node : nodes) {
            nodeByFilterName.add(ValidationFiltersCheck.getStringValue(node));
        }
        return nodeByFilterName;
    }

    private static String getStringValue(Node node) {
        return node.getFirstChild().getNodeValue();
    }
}

