/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.java.matcher.MethodMatcher;
import org.sonar.java.matcher.TypeCriteria;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.java.model.JUtils;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S2175")
public class CollectionInappropriateCallsCheck
extends AbstractMethodDetection {
    @Override
    protected List<MethodMatcher> getMethodInvocationMatchers() {
        return Arrays.asList(CollectionInappropriateCallsCheck.collectionMethodInvocation("remove"), CollectionInappropriateCallsCheck.collectionMethodInvocation("contains"));
    }

    private static MethodMatcher collectionMethodInvocation(String methodName) {
        return MethodMatcher.create().typeDefinition(TypeCriteria.subtypeOf((String)"java.util.Collection")).name(methodName).addParameter("java.lang.Object");
    }

    @Override
    protected void onMethodInvocationFound(MethodInvocationTree tree) {
        ExpressionTree firstArgument = (ExpressionTree)tree.arguments().get(0);
        Type argumentType = firstArgument.symbolType();
        if (argumentType.isUnknown()) {
            return;
        }
        Type collectionType = CollectionInappropriateCallsCheck.getMethodOwner(tree);
        Type collectionParameterType = CollectionInappropriateCallsCheck.getTypeArgument(collectionType);
        boolean isCallToParametrizedOrUnknownMethod = CollectionInappropriateCallsCheck.isCallToParametrizedOrUnknownMethod(firstArgument);
        if (!isCallToParametrizedOrUnknownMethod && tree.methodSelect().is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
            isCallToParametrizedOrUnknownMethod = CollectionInappropriateCallsCheck.isCallToParametrizedOrUnknownMethod(((MemberSelectExpressionTree)tree.methodSelect()).expression());
        }
        if (!(collectionParameterType == null || collectionParameterType.isUnknown() || isCallToParametrizedOrUnknownMethod || CollectionInappropriateCallsCheck.isArgumentCompatible(argumentType, collectionParameterType))) {
            String message = JUtils.isParametrized((Type)collectionType) ? "A \"{0}<{1}>\" cannot contain a \"{2}\"" : "\"{0}\" is a \"Collection<{1}>\" which cannot contain a \"{2}\"";
            this.reportIssue((Tree)ExpressionUtils.methodName((MethodInvocationTree)tree), MessageFormat.format(message, collectionType, collectionParameterType, argumentType));
        }
    }

    private static boolean isCallToParametrizedOrUnknownMethod(ExpressionTree expressionTree) {
        if (expressionTree.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION})) {
            Symbol.MethodSymbol symbol = (Symbol.MethodSymbol)((MethodInvocationTree)expressionTree).symbol();
            return symbol.isUnknown() || JUtils.isParametrizedMethod((Symbol.MethodSymbol)symbol);
        }
        return false;
    }

    private static Type getMethodOwner(MethodInvocationTree mit) {
        if (mit.methodSelect().is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
            return ((MemberSelectExpressionTree)mit.methodSelect()).expression().symbolType();
        }
        return mit.symbol().owner().type();
    }

    @Nullable
    private static Type getTypeArgument(Type collectionType) {
        if (collectionType.is("java.util.Collection") && JUtils.isParametrized((Type)collectionType)) {
            return (Type)JUtils.typeArguments((Type)collectionType).get(0);
        }
        return JUtils.directSuperTypes((Type)collectionType).stream().map(CollectionInappropriateCallsCheck::getTypeArgument).filter(Objects::nonNull).findFirst().orElse(null);
    }

    private static boolean isArgumentCompatible(Type argumentType, Type collectionParameterType) {
        return CollectionInappropriateCallsCheck.isSubtypeOf(argumentType, collectionParameterType) || CollectionInappropriateCallsCheck.isSubtypeOf(collectionParameterType, argumentType) || CollectionInappropriateCallsCheck.autoboxing(argumentType, collectionParameterType);
    }

    private static boolean isSubtypeOf(Type type, Type superType) {
        return type.isSubtypeOf(superType.erasure());
    }

    private static boolean autoboxing(Type argumentType, Type collectionParameterType) {
        return argumentType.isPrimitive() && JUtils.isPrimitiveWrapper((Type)collectionParameterType) && CollectionInappropriateCallsCheck.isSubtypeOf(JUtils.primitiveWrapperType((Type)argumentType), collectionParameterType);
    }
}

