/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.java.checks.helpers.ExpressionsHelper;
import org.sonar.java.matcher.MethodMatcher;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.java.model.LiteralUtils;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.tree.Arguments;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.LiteralTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S2068")
public class HardCodedCredentialsCheck
extends IssuableSubscriptionVisitor {
    private static final String DEFAULT_CREDENTIAL_WORDS = "password,passwd,pwd,passphrase,java.naming.security.credentials";
    private static final Set<String> WHITE_LIST = Collections.singleton("anonymous");
    private static final String JAVA_LANG_STRING = "java.lang.String";
    private static final String JAVA_LANG_OBJECT = "java.lang.Object";
    private static final Pattern URL_PREFIX = Pattern.compile("^\\w{1,8}://");
    private static final Pattern NON_EMPTY_URL_CREDENTIAL = Pattern.compile("(?<user>[^\\s:]*+):(?<password>\\S++)");
    private static final int MINIMUM_PASSWORD_LENGTH = 1;
    private static final MethodMatcher PASSWORD_AUTHENTICATION_CONSTRUCTOR = MethodMatcher.create().typeDefinition("java.net.PasswordAuthentication").name("<init>").addParameter("java.lang.String").addParameter("char[]");
    private static final MethodMatcher STRING_TO_CHAR_ARRAY = MethodMatcher.create().typeDefinition("java.lang.String").name("toCharArray").withoutParameter();
    private static final MethodMatcher EQUALS_MATCHER = MethodMatcher.create().name("equals").parameters(new String[]{"java.lang.Object"});
    private static final MethodMatcher GET_CONNECTION_MATCHER = MethodMatcher.create().typeDefinition("java.sql.DriverManager").name("getConnection").withAnyParameters();
    private static final int GET_CONNECTION_PASSWORD_ARGUMENT = 2;
    @RuleProperty(key="credentialWords", description="Comma separated list of words identifying potential credentials", defaultValue="password,passwd,pwd,passphrase,java.naming.security.credentials")
    public String credentialWords = "password,passwd,pwd,passphrase,java.naming.security.credentials";
    private List<Pattern> variablePatterns = null;
    private List<Pattern> literalPatterns = null;

    private Stream<Pattern> variablePatterns() {
        if (this.variablePatterns == null) {
            this.variablePatterns = this.toPatterns("");
        }
        return this.variablePatterns.stream();
    }

    private Stream<Pattern> literalPatterns() {
        if (this.literalPatterns == null) {
            this.literalPatterns = this.toPatterns("=\\S.");
        }
        return this.literalPatterns.stream();
    }

    private List<Pattern> toPatterns(String suffix) {
        return Stream.of(this.credentialWords.split(",")).map(String::trim).map(word -> Pattern.compile("(" + word + ")" + suffix, 2)).collect(Collectors.toList());
    }

    public List<Tree.Kind> nodesToVisit() {
        return Arrays.asList(Tree.Kind.STRING_LITERAL, Tree.Kind.VARIABLE, Tree.Kind.ASSIGNMENT, Tree.Kind.NEW_CLASS, Tree.Kind.METHOD_INVOCATION);
    }

    public void visitNode(Tree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.STRING_LITERAL})) {
            this.handleStringLiteral((LiteralTree)tree);
        } else if (tree.is(new Tree.Kind[]{Tree.Kind.VARIABLE})) {
            this.handleVariable((VariableTree)tree);
        } else if (tree.is(new Tree.Kind[]{Tree.Kind.ASSIGNMENT})) {
            this.handleAssignment((AssignmentExpressionTree)tree);
        } else if (tree.is(new Tree.Kind[]{Tree.Kind.NEW_CLASS})) {
            this.handleConstructor((NewClassTree)tree);
        } else {
            this.handleMethodInvocation((MethodInvocationTree)tree);
        }
    }

    private Optional<String> isSettingPassword(MethodInvocationTree tree) {
        Arguments arguments = tree.arguments();
        if (arguments.size() == 2 && HardCodedCredentialsCheck.isArgumentsSuperTypeOfString((List<ExpressionTree>)arguments) && !this.isPasswordLikeName((ExpressionTree)arguments.get(1)) && HardCodedCredentialsCheck.isNotExcludedString((ExpressionTree)arguments.get(1))) {
            return this.isPassword((ExpressionTree)arguments.get(0));
        }
        return Optional.empty();
    }

    private Optional<String> isPassword(ExpressionTree argument) {
        String value = ExpressionsHelper.getConstantValueAsString(argument).value();
        if (StringUtils.isEmpty((String)value)) {
            return Optional.empty();
        }
        return this.variablePatterns().map(pattern -> pattern.matcher(value)).filter(Matcher::matches).map(matcher -> matcher.group(1)).findAny();
    }

    private Optional<String> isPasswordVariableName(IdentifierTree identifierTree) {
        return this.isPasswordLikeName(identifierTree.name());
    }

    private boolean isPasswordLikeName(ExpressionTree expression) {
        if (expression.is(new Tree.Kind[]{Tree.Kind.STRING_LITERAL})) {
            return this.isPasswordLikeName(LiteralUtils.trimQuotes((String)((LiteralTree)expression).value())).isPresent();
        }
        return false;
    }

    private Optional<String> isPasswordLikeName(String name) {
        return this.variablePatterns().map(pattern -> pattern.matcher(name)).filter(Matcher::find).map(matcher -> matcher.group(1)).findAny();
    }

    private Optional<String> isPasswordVariable(ExpressionTree variable) {
        if (variable.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
            return this.isPasswordVariableName(((MemberSelectExpressionTree)variable).identifier());
        }
        if (variable.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
            return this.isPasswordVariableName((IdentifierTree)variable);
        }
        return Optional.empty();
    }

    private static boolean isCallOnStringLiteral(ExpressionTree expr) {
        return expr.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT}) && HardCodedCredentialsCheck.isNotExcludedString(((MemberSelectExpressionTree)expr).expression());
    }

    private void handleStringLiteral(LiteralTree tree) {
        String cleanedLiteral = LiteralUtils.trimQuotes((String)tree.value());
        if (HardCodedCredentialsCheck.isURLWithCredentials(cleanedLiteral)) {
            this.reportIssue((Tree)tree, "Review this hard-coded URL, which may contain a credential.");
        } else if (!this.isPartOfConstantPasswordDeclaration(tree)) {
            this.literalPatterns().map(pattern -> pattern.matcher(cleanedLiteral)).filter(Matcher::find).map(matcher -> matcher.group(1)).filter(match -> !HardCodedCredentialsCheck.isExcludedLiteral(cleanedLiteral, match)).findAny().ifPresent(credential -> this.report((Tree)tree, (String)credential));
        }
    }

    private static boolean isURLWithCredentials(String stringLiteral) {
        if (URL_PREFIX.matcher(stringLiteral).find()) {
            try {
                String userInfo = new URL(stringLiteral).getUserInfo();
                if (userInfo != null) {
                    Matcher matcher = NON_EMPTY_URL_CREDENTIAL.matcher(userInfo);
                    return matcher.matches() && !matcher.group("user").equals(matcher.group("password"));
                }
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return false;
    }

    private boolean isPartOfConstantPasswordDeclaration(LiteralTree tree) {
        Tree parent = tree.parent();
        return parent != null && parent.is(new Tree.Kind[]{Tree.Kind.VARIABLE}) && this.isPasswordVariableName(((VariableTree)parent).simpleName()).isPresent();
    }

    private static boolean isExcludedLiteral(String cleanedLiteral, String match) {
        String followingString = cleanedLiteral.substring(cleanedLiteral.indexOf(match) + match.length() + 1);
        return !HardCodedCredentialsCheck.isNotExcludedString(followingString) || followingString.startsWith("?") || followingString.startsWith(":") || followingString.startsWith("\\\"") || followingString.contains("%s");
    }

    private void handleVariable(VariableTree tree) {
        IdentifierTree variable = tree.simpleName();
        this.isPasswordVariableName(variable).filter(passwordVariableName -> {
            ExpressionTree initializer = tree.initializer();
            return initializer != null && HardCodedCredentialsCheck.isNotExcluded(initializer) && this.isNotPasswordConst(initializer);
        }).ifPresent(passwordVariableName -> this.report((Tree)variable, (String)passwordVariableName));
    }

    private void handleAssignment(AssignmentExpressionTree tree) {
        ExpressionTree variable = tree.variable();
        this.isPasswordVariable(variable).filter(passwordVariableName -> HardCodedCredentialsCheck.isNotExcluded(tree.expression())).ifPresent(passwordVariableName -> this.report((Tree)variable, (String)passwordVariableName));
    }

    private static boolean isArgumentsSuperTypeOfString(List<ExpressionTree> arguments) {
        return arguments.stream().allMatch(arg -> arg.symbolType().is(JAVA_LANG_STRING) || arg.symbolType().is(JAVA_LANG_OBJECT));
    }

    private boolean isNotPasswordConst(ExpressionTree expression) {
        if (expression.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION})) {
            ExpressionTree methodSelect = ((MethodInvocationTree)expression).methodSelect();
            return methodSelect.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT}) && this.isNotPasswordConst(((MemberSelectExpressionTree)methodSelect).expression());
        }
        String literal = ExpressionsHelper.getConstantValueAsString(expression).value();
        return literal == null || this.variablePatterns().map(pattern -> pattern.matcher(literal)).noneMatch(Matcher::find);
    }

    private static boolean isNotExcluded(ExpressionTree expression) {
        if (expression.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION})) {
            MethodInvocationTree mit = (MethodInvocationTree)expression;
            return STRING_TO_CHAR_ARRAY.matches(mit) && HardCodedCredentialsCheck.isCallOnStringLiteral(mit.methodSelect());
        }
        return HardCodedCredentialsCheck.isNotExcludedString(expression);
    }

    private static boolean isNotExcludedString(ExpressionTree expression) {
        return HardCodedCredentialsCheck.isNotExcludedString(ExpressionsHelper.getConstantValueAsString(expression).value());
    }

    private static boolean isNotExcludedString(@Nullable String literal) {
        return literal != null && !literal.trim().isEmpty() && literal.length() > 1 && !WHITE_LIST.contains(literal);
    }

    private void handleConstructor(NewClassTree tree) {
        MethodInvocationTree mit;
        if (!PASSWORD_AUTHENTICATION_CONSTRUCTOR.matches(tree)) {
            return;
        }
        ExpressionTree secondArg = (ExpressionTree)tree.arguments().get(1);
        if (secondArg.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION}) && STRING_TO_CHAR_ARRAY.matches(mit = (MethodInvocationTree)secondArg) && HardCodedCredentialsCheck.isCallOnStringLiteral(mit.methodSelect())) {
            this.reportIssue((Tree)tree, "Remove this hard-coded password.");
        }
    }

    private void handleMethodInvocation(MethodInvocationTree mit) {
        ExpressionTree methodSelect = mit.methodSelect();
        if (EQUALS_MATCHER.matches(mit) && methodSelect.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
            this.handleEqualsMethod(mit, (MemberSelectExpressionTree)methodSelect);
        } else if (GET_CONNECTION_MATCHER.matches(mit)) {
            this.handleGetConnectionMethod(mit);
        } else {
            this.isSettingPassword(mit).ifPresent(settingPassword -> this.report((Tree)ExpressionUtils.methodName((MethodInvocationTree)mit), (String)settingPassword));
        }
    }

    private void handleEqualsMethod(MethodInvocationTree mit, MemberSelectExpressionTree methodSelect) {
        ExpressionTree leftExpression = methodSelect.expression();
        ExpressionTree rightExpression = (ExpressionTree)mit.arguments().get(0);
        this.isPasswordVariable(leftExpression).filter(passwordVariableName -> HardCodedCredentialsCheck.isNotExcludedString(rightExpression) && !this.isPasswordLikeName(rightExpression)).ifPresent(passwordVariableName -> this.report((Tree)leftExpression, (String)passwordVariableName));
        this.isPasswordVariable(rightExpression).filter(passwordVariableName -> HardCodedCredentialsCheck.isNotExcludedString(leftExpression) && !this.isPasswordLikeName(leftExpression)).ifPresent(passwordVariableName -> this.report((Tree)rightExpression, (String)passwordVariableName));
    }

    private void handleGetConnectionMethod(MethodInvocationTree mit) {
        ExpressionTree expression;
        if (mit.arguments().size() > 2 && HardCodedCredentialsCheck.isNotExcludedString(expression = (ExpressionTree)mit.arguments().get(2))) {
            this.reportIssue((Tree)expression, "Remove this hard-coded password.");
        }
    }

    private void report(Tree tree, String match) {
        this.reportIssue(tree, "'" + match + "' detected in this expression, review this potentially hard-coded credential.");
    }
}

