/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.sonar.check.Rule;
import org.sonar.java.matcher.MethodMatcher;
import org.sonar.java.matcher.MethodMatcherCollection;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.SymbolMetadata;
import org.sonar.plugins.java.api.tree.BlockTree;
import org.sonar.plugins.java.api.tree.ExpressionStatementTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S1607")
public class IgnoredTestsCheck
extends IssuableSubscriptionVisitor {
    private static final String ORG_JUNIT_ASSUME = "org.junit.Assume";
    private static final String BOOLEAN_TYPE = "boolean";
    private static final MethodMatcherCollection ASSUME_METHODS = MethodMatcherCollection.create((MethodMatcher[])new MethodMatcher[]{MethodMatcher.create().typeDefinition("org.junit.Assume").name("assumeTrue").parameters(new String[]{"boolean"}), MethodMatcher.create().typeDefinition("org.junit.Assume").name("assumeFalse").parameters(new String[]{"boolean"})});

    public List<Tree.Kind> nodesToVisit() {
        return Arrays.asList(Tree.Kind.METHOD, Tree.Kind.CONSTRUCTOR);
    }

    public void visitNode(Tree tree) {
        BlockTree block;
        if (!this.hasSemantic()) {
            return;
        }
        MethodTree methodTree = (MethodTree)tree;
        SymbolMetadata symbolMetadata = methodTree.symbol().metadata();
        if (IgnoredTestsCheck.isSilentlyIgnored(symbolMetadata, "org.junit.Ignore") || IgnoredTestsCheck.isSilentlyIgnored(symbolMetadata, "org.junit.jupiter.api.Disabled")) {
            this.reportIssue((Tree)methodTree.simpleName(), "Fix or remove this skipped unit test");
        }
        if ((block = methodTree.block()) != null) {
            block.body().stream().filter(s -> s.is(new Tree.Kind[]{Tree.Kind.EXPRESSION_STATEMENT})).map(s -> ((ExpressionStatementTree)s).expression()).filter(s -> s.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION})).map(MethodInvocationTree.class::cast).filter(arg_0 -> ((MethodMatcherCollection)ASSUME_METHODS).anyMatch(arg_0)).filter(IgnoredTestsCheck::hasConstantOppositeArg).forEach(mit -> this.reportIssue((Tree)mit.methodSelect(), "Fix or remove this skipped unit test"));
        }
    }

    private static boolean isSilentlyIgnored(SymbolMetadata symbolMetadata, String annotation) {
        List annotationValues = symbolMetadata.valuesForAnnotation(annotation);
        return annotationValues != null && annotationValues.isEmpty();
    }

    private static boolean hasConstantOppositeArg(MethodInvocationTree mit) {
        Optional result = ((ExpressionTree)mit.arguments().get(0)).asConstant(Boolean.class);
        return result.isPresent() && !((Boolean)result.get()).equals(mit.symbol().name().contains("True"));
    }
}

