/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import java.util.Locale;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.sonar.check.Rule;
import org.sonar.java.matcher.MethodMatcher;
import org.sonar.java.matcher.MethodMatcherCollection;
import org.sonar.java.matcher.TypeCriteria;
import org.sonar.java.model.JUtils;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.BinaryExpressionTree;
import org.sonar.plugins.java.api.tree.CatchTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.IfStatementTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;

@Rule(key="S2629")
public class LazyArgEvaluationCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    private static final TypeCriteria STRING = TypeCriteria.is((String)"java.lang.String");
    private static final TypeCriteria OBJECT_ARR = TypeCriteria.is((String)"java.lang.Object[]");
    private static final MethodMatcher PRECONDITIONS = MethodMatcher.create().typeDefinition("com.google.common.base.Preconditions").name("checkState").withAnyParameters();
    private static final MethodMatcherCollection LAZY_ARG_METHODS = MethodMatcherCollection.create((MethodMatcher[])new MethodMatcher[]{PRECONDITIONS, LogLevels.JUL.access$200(), LogLevels.LOG4J.access$300()});
    private static final MethodMatcherCollection LOG_LEVEL_TESTS;
    private JavaFileScannerContext context;
    private Deque<Tree> treeStack = new ArrayDeque<Tree>();

    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        if (context.getSemanticModel() == null) {
            return;
        }
        this.scan((Tree)context.getTree());
    }

    public void visitMethodInvocation(MethodInvocationTree tree) {
        if (LAZY_ARG_METHODS.anyMatch(tree) && !this.insideCatchStatement() && !this.insideLevelTest() && !LazyArgEvaluationCheck.argsUsingSuppliers(tree)) {
            this.onMethodInvocationFound(tree);
        }
    }

    private static boolean argsUsingSuppliers(MethodInvocationTree tree) {
        return tree.arguments().stream().map(ExpressionTree::symbolType).anyMatch(LogLevels.LOG4J.SUPPLIER::test);
    }

    public void visitIfStatement(IfStatementTree ifTree) {
        LevelTestVisitor levelTestVisitor = new LevelTestVisitor();
        ifTree.condition().accept((TreeVisitor)levelTestVisitor);
        if (levelTestVisitor.match) {
            this.stackAndContinue(ifTree, x$0 -> super.visitIfStatement(x$0));
        } else {
            super.visitIfStatement(ifTree);
        }
    }

    public void visitCatch(CatchTree tree) {
        this.stackAndContinue(tree, x$0 -> super.visitCatch(x$0));
    }

    public void visitMethod(MethodTree tree) {
        this.stackAndContinue(tree, x$0 -> super.visitMethod(x$0));
    }

    private boolean insideLevelTest() {
        return this.treeStack.stream().anyMatch(t -> t.is(new Tree.Kind[]{Tree.Kind.IF_STATEMENT}));
    }

    private boolean insideCatchStatement() {
        return this.treeStack.peek() != null && this.treeStack.peek().is(new Tree.Kind[]{Tree.Kind.CATCH});
    }

    private <T extends Tree> void stackAndContinue(T tree, Consumer<T> visit) {
        this.treeStack.push(tree);
        visit.accept(tree);
        this.treeStack.pop();
    }

    private void onMethodInvocationFound(MethodInvocationTree mit) {
        List flow = LazyArgEvaluationCheck.findStringArg(mit).flatMap(LazyArgEvaluationCheck::checkArgument).collect(Collectors.toList());
        if (!flow.isEmpty()) {
            this.context.reportIssue((JavaCheck)this, ((JavaFileScannerContext.Location)flow.get((int)0)).syntaxNode, ((JavaFileScannerContext.Location)flow.get((int)0)).msg, flow.subList(1, flow.size()), null);
        }
    }

    private static Stream<JavaFileScannerContext.Location> checkArgument(ExpressionTree stringArgument) {
        StringExpressionVisitor visitor = new StringExpressionVisitor();
        stringArgument.accept((TreeVisitor)visitor);
        if (visitor.shouldReport) {
            return Stream.of(LazyArgEvaluationCheck.locationFromArg(stringArgument, visitor));
        }
        return Stream.empty();
    }

    private static JavaFileScannerContext.Location locationFromArg(ExpressionTree stringArgument, StringExpressionVisitor visitor) {
        StringBuilder msg = new StringBuilder();
        if (visitor.hasMethodInvocation) {
            msg.append("Invoke method(s) only conditionally. ");
        }
        if (visitor.hasBinaryExpression) {
            msg.append("Use the built-in formatting to construct this argument.");
        }
        return new JavaFileScannerContext.Location(msg.toString(), (Tree)stringArgument);
    }

    private static Stream<ExpressionTree> findStringArg(MethodInvocationTree mit) {
        return mit.arguments().stream().filter(arg -> arg.symbolType().is("java.lang.String"));
    }

    static {
        LogLevels.logLevels().map(LogLevels::log).forEach(arg_0 -> ((MethodMatcherCollection)LAZY_ARG_METHODS).addAll(arg_0));
        LOG_LEVEL_TESTS = MethodMatcherCollection.create((MethodMatcher[])new MethodMatcher[0]).addAll((Collection)LogLevels.LOG4J.TESTS);
        LogLevels.logLevels().map(LogLevels::test).forEach(arg_0 -> ((MethodMatcherCollection)LOG_LEVEL_TESTS).add(arg_0));
    }

    private static class LevelTestVisitor
    extends BaseTreeVisitor {
        boolean match = false;

        private LevelTestVisitor() {
        }

        public void visitMethodInvocation(MethodInvocationTree mit) {
            if (LOG_LEVEL_TESTS.anyMatch(mit)) {
                this.match = true;
            }
        }
    }

    private static class StringExpressionVisitor
    extends BaseTreeVisitor {
        private boolean hasBinaryExpression;
        private boolean shouldReport;
        private boolean hasMethodInvocation;

        private StringExpressionVisitor() {
        }

        public void visitMethodInvocation(MethodInvocationTree tree) {
            if (!StringExpressionVisitor.isGetter(tree) && !StringExpressionVisitor.isAnnotationMethod(tree)) {
                this.shouldReport = true;
                this.hasMethodInvocation = true;
            }
        }

        private static boolean isGetter(MethodInvocationTree tree) {
            String methodName = tree.symbol().name();
            return methodName != null && (methodName.startsWith("get") || methodName.startsWith("is"));
        }

        private static boolean isAnnotationMethod(MethodInvocationTree tree) {
            Symbol owner = tree.symbol().owner();
            return owner.isTypeSymbol() && JUtils.isAnnotation((Symbol.TypeSymbol)((Symbol.TypeSymbol)owner));
        }

        public void visitIdentifier(IdentifierTree tree) {
            if (this.hasBinaryExpression) {
                this.shouldReport = true;
            }
        }

        public void visitNewClass(NewClassTree tree) {
            this.hasMethodInvocation = true;
            this.shouldReport = true;
        }

        public void visitBinaryExpression(BinaryExpressionTree tree) {
            this.hasBinaryExpression = true;
            if (!StringExpressionVisitor.isConstant(tree.rightOperand())) {
                tree.rightOperand().accept((TreeVisitor)this);
            }
            if (!StringExpressionVisitor.isConstant(tree.leftOperand())) {
                tree.leftOperand().accept((TreeVisitor)this);
            }
        }

        private static boolean isConstant(ExpressionTree operand) {
            switch (operand.kind()) {
                case BOOLEAN_LITERAL: 
                case CHAR_LITERAL: 
                case DOUBLE_LITERAL: 
                case FLOAT_LITERAL: 
                case INT_LITERAL: 
                case LONG_LITERAL: 
                case STRING_LITERAL: 
                case NULL_LITERAL: {
                    return true;
                }
                case IDENTIFIER: {
                    return StringExpressionVisitor.isConstant(((IdentifierTree)operand).symbol());
                }
                case MEMBER_SELECT: {
                    MemberSelectExpressionTree mset = (MemberSelectExpressionTree)operand;
                    return StringExpressionVisitor.isConstant(mset.identifier().symbol());
                }
            }
            return false;
        }

        private static boolean isConstant(Symbol symbol) {
            return symbol.isStatic() && symbol.isFinal();
        }
    }

    static interface LogLevels {
        public List<MethodMatcher> log();

        public MethodMatcher test();

        public static Stream<LogLevels> logLevels() {
            return Stream.of(SLF4J.values(), JUL.values(), LOG4J.values()).flatMap(Arrays::stream);
        }

        public static MethodMatcher levelTestMatcher(TypeCriteria typeDefinition, String level) {
            return MethodMatcher.create().typeDefinition(typeDefinition).name(String.format("is%c%sEnabled", Character.valueOf(level.charAt(0)), level.toLowerCase(Locale.ROOT).substring(1)));
        }

        public static enum LOG4J implements LogLevels
        {
            DEBUG,
            ERROR,
            FATAL,
            INFO,
            TRACE,
            WARN;

            private static final String LEVEL = "org.apache.logging.log4j.Level";
            private static final TypeCriteria LOGGER;
            private static final TypeCriteria MARKER;
            private static final Predicate<Type> SUPPLIER;
            private static final List<MethodMatcher> TESTS;
            private static final MethodMatcher LOG;

            @Override
            public List<MethodMatcher> log() {
                return Collections.singletonList(MethodMatcher.create().typeDefinition(LOGGER).name(this.toString().toLowerCase(Locale.ROOT)).withAnyParameters());
            }

            @Override
            public MethodMatcher test() {
                return LogLevels.levelTestMatcher(LOGGER, this.toString()).withAnyParameters();
            }

            static /* synthetic */ MethodMatcher access$300() {
                return LOG;
            }

            static {
                LOGGER = TypeCriteria.subtypeOf((String)"org.apache.logging.log4j.Logger");
                MARKER = TypeCriteria.is((String)"org.apache.logging.log4j.Marker");
                SUPPLIER = TypeCriteria.subtypeOf((String)"org.apache.logging.log4j.util.Supplier").or((Predicate)TypeCriteria.subtypeOf((String)"org.apache.logging.log4j.util.MessageSupplier"));
                TESTS = Arrays.asList(MethodMatcher.create().typeDefinition(LOGGER).name("isEnabled").addParameter(LEVEL), MethodMatcher.create().typeDefinition(LOGGER).name("isEnabled").addParameter(LEVEL).addParameter(MARKER));
                LOG = MethodMatcher.create().typeDefinition(LOGGER).name("log").withAnyParameters();
            }
        }

        public static enum JUL implements LogLevels
        {
            SEVERE,
            WARNING,
            INFO,
            CONFIG,
            FINE,
            FINER,
            FINEST;

            private static final String LOGGER = "java.util.logging.Logger";
            private static final MethodMatcher LOG;

            @Override
            public List<MethodMatcher> log() {
                return Collections.singletonList(MethodMatcher.create().typeDefinition(LOGGER).name(this.toString().toLowerCase(Locale.ROOT)).addParameter(STRING));
            }

            @Override
            public MethodMatcher test() {
                return MethodMatcher.create().typeDefinition(LOGGER).name("isLoggable").addParameter("java.util.logging.Level");
            }

            static /* synthetic */ MethodMatcher access$200() {
                return LOG;
            }

            static {
                LOG = MethodMatcher.create().typeDefinition(LOGGER).name("log").addParameter("java.util.logging.Level").addParameter(STRING);
            }
        }

        public static enum SLF4J implements LogLevels
        {
            TRACE,
            DEBUG,
            INFO,
            WARN,
            ERROR;

            private static final TypeCriteria LOGGER;
            private static final TypeCriteria MARKER;

            @Override
            public List<MethodMatcher> log() {
                return SLF4J.slf4jVariants(() -> MethodMatcher.create().typeDefinition(LOGGER).name(this.toString().toLowerCase(Locale.ROOT)));
            }

            @Override
            public MethodMatcher test() {
                return LogLevels.levelTestMatcher(LOGGER, this.toString()).withoutParameter();
            }

            private static List<MethodMatcher> slf4jVariants(Supplier<MethodMatcher> prototype) {
                return Arrays.asList(prototype.get().parameters(new TypeCriteria[]{STRING}), prototype.get().parameters(new TypeCriteria[]{STRING, TypeCriteria.anyType()}), prototype.get().parameters(new TypeCriteria[]{STRING, TypeCriteria.anyType(), TypeCriteria.anyType()}), prototype.get().parameters(new TypeCriteria[]{STRING, OBJECT_ARR}), prototype.get().parameters(new TypeCriteria[]{MARKER, STRING}), prototype.get().parameters(new TypeCriteria[]{MARKER, STRING, TypeCriteria.anyType()}), prototype.get().parameters(new TypeCriteria[]{MARKER, STRING, TypeCriteria.anyType(), TypeCriteria.anyType()}), prototype.get().parameters(new TypeCriteria[]{MARKER, STRING, OBJECT_ARR}));
            }

            static {
                LOGGER = TypeCriteria.subtypeOf((String)"org.slf4j.Logger");
                MARKER = TypeCriteria.is((String)"org.slf4j.Marker");
            }
        }
    }
}

