/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Collections;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.matcher.MethodMatcher;
import org.sonar.java.matcher.MethodMatcherCollection;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.ListTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;
import org.sonar.plugins.java.api.tree.TypeCastTree;

@Rule(key="S2140")
public class RandomFloatToIntCheck
extends IssuableSubscriptionVisitor {
    private static final String NEXT_FLOAT = "nextFloat";
    private static final String NEXT_DOUBLE = "nextDouble";
    private final MethodMatcher mathRandomMethodMatcher = MethodMatcher.create().typeDefinition("java.lang.Math").name("random").withoutParameter();
    private final MethodMatcherCollection methodMatchers = MethodMatcherCollection.create((MethodMatcher[])new MethodMatcher[]{MethodMatcher.create().typeDefinition("java.util.Random").name("nextDouble").withoutParameter(), MethodMatcher.create().typeDefinition("java.util.Random").name("nextFloat").withoutParameter(), MethodMatcher.create().typeDefinition("java.util.concurrent.ThreadLocalRandom").name("nextDouble").withAnyParameters(), MethodMatcher.create().typeDefinition("org.apache.commons.lang.math.JVMRandom").name("nextDouble").withoutParameter(), MethodMatcher.create().typeDefinition("org.apache.commons.lang.math.JVMRandom").name("nextFloat").withoutParameter(), MethodMatcher.create().typeDefinition("org.apache.commons.lang.math.RandomUtils").name("nextDouble").withoutParameter(), MethodMatcher.create().typeDefinition("org.apache.commons.lang.math.RandomUtils").name("nextFloat").withoutParameter(), MethodMatcher.create().typeDefinition("org.apache.commons.lang3.RandomUtils").name("nextDouble").withoutParameter(), MethodMatcher.create().typeDefinition("org.apache.commons.lang3.RandomUtils").name("nextFloat").withoutParameter()});

    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.TYPE_CAST);
    }

    public void visitNode(Tree tree) {
        TypeCastTree castTree = (TypeCastTree)tree;
        if (castTree.type().symbolType().is("int")) {
            castTree.expression().accept((TreeVisitor)new RandomDoubleVisitor());
        }
    }

    private class RandomDoubleVisitor
    extends BaseTreeVisitor {
        private RandomDoubleVisitor() {
        }

        public void visitMethodInvocation(MethodInvocationTree tree) {
            if (RandomFloatToIntCheck.this.mathRandomMethodMatcher.matches(tree)) {
                RandomFloatToIntCheck.this.reportIssue((Tree)tree.methodSelect(), "Use \"java.util.Random.nextInt()\" instead.");
            } else if (RandomFloatToIntCheck.this.methodMatchers.anyMatch(tree)) {
                RandomFloatToIntCheck.this.reportIssue((Tree)tree.methodSelect(), "Use \"nextInt()\" instead.");
            }
            super.visitMethodInvocation(tree);
        }

        public void visitNewClass(NewClassTree tree) {
            this.scan((Tree)tree.enclosingExpression());
            this.scan((Tree)tree.identifier());
            this.scan((ListTree)tree.typeArguments());
            this.scan((ListTree)tree.arguments());
        }
    }
}

