/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.java.model.JUtils;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TypeTree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S4276")
public class SpecializedFunctionalInterfacesCheck
extends IssuableSubscriptionVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return Arrays.asList(Tree.Kind.CLASS, Tree.Kind.VARIABLE);
    }

    public void visitNode(Tree tree) {
        if (!this.hasSemantic()) {
            return;
        }
        if (tree.is(new Tree.Kind[]{Tree.Kind.CLASS})) {
            this.checkClassInterfaces((ClassTree)tree);
        } else {
            this.checkVariableTypeAndInitializer((VariableTree)tree);
        }
    }

    private void checkClassInterfaces(ClassTree tree) {
        List<InterfaceTreeAndStringPairReport> reportTreeAndStringInterfaces = tree.superInterfaces().stream().map(typeTree -> SpecializedFunctionalInterfacesCheck.matchFunctionalInterface(typeTree.symbolType()).map(rs -> new InterfaceTreeAndStringPairReport((String)rs, (TypeTree)typeTree)).orElse(null)).filter(Objects::nonNull).collect(Collectors.toList());
        if (reportTreeAndStringInterfaces.isEmpty()) {
            return;
        }
        List secondaryLocations = reportTreeAndStringInterfaces.stream().map(interf -> new JavaFileScannerContext.Location("", (Tree)interf.classInterface)).collect(Collectors.toList());
        this.reportIssue((Tree)tree.simpleName(), SpecializedFunctionalInterfacesCheck.reportMessage(reportTreeAndStringInterfaces), secondaryLocations, null);
    }

    private void checkVariableTypeAndInitializer(VariableTree variableTree) {
        ExpressionTree initializer = variableTree.initializer();
        if (variableTree.symbol().owner().isMethodSymbol() && !variableTree.parent().is(new Tree.Kind[]{Tree.Kind.LAMBDA_EXPRESSION}) || initializer != null && (initializer.is(new Tree.Kind[]{Tree.Kind.LAMBDA_EXPRESSION}) || SpecializedFunctionalInterfacesCheck.isAnonymousClass(initializer))) {
            SpecializedFunctionalInterfacesCheck.matchFunctionalInterface(variableTree.symbol().type()).ifPresent(reportString -> {
                TypeTree variableType = variableTree.type();
                this.reportIssue((Tree)variableType, SpecializedFunctionalInterfacesCheck.reportMessage(new InterfaceTreeAndStringPairReport((String)reportString, variableType)));
            });
        }
    }

    private static String reportMessage(InterfaceTreeAndStringPairReport onlyOneInterface) {
        return SpecializedFunctionalInterfacesCheck.reportMessage(Collections.singletonList(onlyOneInterface));
    }

    private static String reportMessage(List<InterfaceTreeAndStringPairReport> interfacesToBeReported) {
        String functionalInterfaces = interfacesToBeReported.stream().map(x -> x.reportString).collect(Collectors.joining("', '", interfacesToBeReported.size() > 1 ? "s '" : " '", "'"));
        return String.format("Refactor this code to use the more specialised Functional Interface%s", functionalInterfaces);
    }

    private static boolean isAnonymousClass(ExpressionTree initializeTree) {
        return initializeTree.is(new Tree.Kind[]{Tree.Kind.NEW_CLASS}) && ((NewClassTree)initializeTree).classBody() != null;
    }

    private static Optional<String> matchFunctionalInterface(Type type) {
        if (!JUtils.isParametrized((Type)type)) {
            return Optional.empty();
        }
        if (SpecializedFunctionalInterfacesCheck.hasAnyUnknownTypeArgument(type)) {
            return Optional.empty();
        }
        switch (type.fullyQualifiedName()) {
            case "java.util.function.Function": {
                return SpecializedFunctionalInterfacesCheck.handleFunctionInterface(type);
            }
            case "java.util.function.BiFunction": {
                return SpecializedFunctionalInterfacesCheck.handleBiFunctionInterface(type);
            }
            case "java.util.function.BiConsumer": {
                return SpecializedFunctionalInterfacesCheck.handleBiConsumerInterface(type);
            }
            case "java.util.function.Supplier": {
                return SpecializedFunctionalInterfacesCheck.handleSupplier(type);
            }
            case "java.util.function.Consumer": 
            case "java.util.function.Predicate": 
            case "java.util.function.UnaryOperator": 
            case "java.util.function.BinaryOperator": {
                return SpecializedFunctionalInterfacesCheck.handleSingleParameterFunctions(type);
            }
        }
        return Optional.empty();
    }

    private static boolean hasAnyUnknownTypeArgument(Type parametrizedType) {
        return JUtils.typeArguments((Type)parametrizedType).stream().anyMatch(Type::isUnknown);
    }

    private static Optional<String> handleSingleParameterFunctions(Type parametrizedType) {
        return Optional.ofNullable(new ParameterTypeNameAndTreeType((Type)parametrizedType, (int)0).paramTypeName).map(s -> s + parametrizedType.name());
    }

    private static Optional<String> handleFunctionInterface(Type parametrizedType) {
        ParameterTypeNameAndTreeType firstArgument = new ParameterTypeNameAndTreeType(parametrizedType, 0);
        ParameterTypeNameAndTreeType secondArgument = new ParameterTypeNameAndTreeType(parametrizedType, 1);
        if (firstArgument.paramType.equals(secondArgument.paramType)) {
            if (firstArgument.paramTypeName != null) {
                return SpecializedFunctionalInterfacesCheck.functionalInterfaceName("%sUnaryOperator", firstArgument.paramTypeName);
            }
            return SpecializedFunctionalInterfacesCheck.functionalInterfaceName("UnaryOperator<%s>", firstArgument.paramType);
        }
        if (SpecializedFunctionalInterfacesCheck.isBoolean(secondArgument)) {
            return SpecializedFunctionalInterfacesCheck.functionalInterfaceName("Predicate<%s>", firstArgument.paramType);
        }
        if (SpecializedFunctionalInterfacesCheck.isBoolean(firstArgument)) {
            return Optional.empty();
        }
        if (firstArgument.paramTypeName != null && secondArgument.paramTypeName != null) {
            return SpecializedFunctionalInterfacesCheck.functionalInterfaceName("%sTo%sFunction", firstArgument.paramTypeName, secondArgument.paramTypeName);
        }
        if (firstArgument.paramTypeName == null && secondArgument.paramTypeName != null) {
            return SpecializedFunctionalInterfacesCheck.functionalInterfaceName("To%sFunction<%s>", secondArgument.paramTypeName, firstArgument.paramType);
        }
        if (firstArgument.paramTypeName != null) {
            return SpecializedFunctionalInterfacesCheck.functionalInterfaceName("%sFunction<%s>", firstArgument.paramTypeName, secondArgument.paramType);
        }
        return Optional.empty();
    }

    private static Optional<String> handleBiFunctionInterface(Type parametrizedType) {
        ParameterTypeNameAndTreeType firstArgument = new ParameterTypeNameAndTreeType(parametrizedType, 0);
        ParameterTypeNameAndTreeType secondArgument = new ParameterTypeNameAndTreeType(parametrizedType, 1);
        ParameterTypeNameAndTreeType thirdArgument = new ParameterTypeNameAndTreeType(parametrizedType, 2);
        if (firstArgument.paramType.equals(secondArgument.paramType) && firstArgument.paramType.equals(thirdArgument.paramType)) {
            return SpecializedFunctionalInterfacesCheck.functionalInterfaceName("BinaryOperator<%s>", firstArgument.paramType);
        }
        if (SpecializedFunctionalInterfacesCheck.isBoolean(thirdArgument)) {
            return SpecializedFunctionalInterfacesCheck.functionalInterfaceName("BiPredicate<%s, %s>", firstArgument.paramType, secondArgument.paramType);
        }
        return Optional.empty();
    }

    private static Optional<String> functionalInterfaceName(String pattern, Object ... args) {
        return Optional.of(String.format(pattern, args));
    }

    private static Optional<String> handleBiConsumerInterface(Type parametrizedType) {
        ParameterTypeNameAndTreeType firstArgument = new ParameterTypeNameAndTreeType(parametrizedType, 0);
        ParameterTypeNameAndTreeType secondArgument = new ParameterTypeNameAndTreeType(parametrizedType, 1);
        if (secondArgument.paramTypeName != null) {
            return Optional.of(String.format("Obj%sConsumer<%s>", secondArgument.paramTypeName, firstArgument.paramType));
        }
        return Optional.empty();
    }

    private static Optional<String> handleSupplier(Type parametrizedType) {
        ParameterTypeNameAndTreeType supplierParamType = new ParameterTypeNameAndTreeType(parametrizedType, 0);
        if (SpecializedFunctionalInterfacesCheck.isBoolean(supplierParamType)) {
            return Optional.of("BooleanSupplier");
        }
        return Optional.ofNullable(supplierParamType.paramTypeName).map(s -> s + "Supplier");
    }

    private static boolean isBoolean(ParameterTypeNameAndTreeType type) {
        return type.paramType.is("java.lang.Boolean");
    }

    private static class ParameterTypeNameAndTreeType {
        final Type paramType;
        @Nullable
        final String paramTypeName;

        ParameterTypeNameAndTreeType(Type parametrizedType, int typeArgumentIndex) {
            this.paramType = (Type)JUtils.typeArguments((Type)parametrizedType).get(typeArgumentIndex);
            this.paramTypeName = ParameterTypeNameAndTreeType.returnStringFromJavaObject(this.paramType);
        }

        @CheckForNull
        private static String returnStringFromJavaObject(Type argType) {
            if (argType.is("java.lang.Integer")) {
                return "Int";
            }
            if (argType.is("java.lang.Double") || argType.is("java.lang.Long")) {
                return argType.name();
            }
            return null;
        }
    }

    private static class InterfaceTreeAndStringPairReport {
        final String reportString;
        final TypeTree classInterface;

        InterfaceTreeAndStringPairReport(String report, TypeTree interf) {
            this.reportString = report;
            this.classInterface = interf;
        }
    }
}

