/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.sonar.check.Rule;
import org.sonar.java.JavaVersionAwareVisitor;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.java.matcher.MethodMatcher;
import org.sonar.plugins.java.api.JavaVersion;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.Arguments;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S4719")
public class StandardCharsetsConstantsCheck
extends AbstractMethodDetection
implements JavaVersionAwareVisitor {
    private static final String INT = "int";
    private static final String BOOLEAN = "boolean";
    private static final String BYTE_ARRAY = "byte[]";
    private static final String TO_STRING = "toString";
    private static final String WRITE = "write";
    private static final String JAVA_IO_FILE = "java.io.File";
    private static final String JAVA_IO_INPUTSTREAM = "java.io.InputStream";
    private static final String JAVA_IO_OUTPUTSTREAM = "java.io.OutputStream";
    private static final String JAVA_IO_OUTPUTSTREAMWRITER = "java.io.OutputStreamWriter";
    private static final String JAVA_IO_INPUTSTREAMREADER = "java.io.InputStreamReader";
    private static final String JAVA_IO_BYTEARRAYOUTPUTSTREAM = "java.io.ByteArrayOutputStream";
    private static final String JAVA_IO_WRITER = "java.io.Writer";
    private static final String JAVA_IO_READER = "java.io.Reader";
    private static final String JAVA_NIO_CHARSET = "java.nio.charset.Charset";
    private static final String JAVA_NIO_FILE_PATH = "java.nio.file.Path";
    private static final String JAVA_NIO_CHANNELS_READABLEBYTECHANNEL = "java.nio.channels.ReadableByteChannel";
    private static final String JAVA_NET_URI = "java.net.URI";
    private static final String JAVA_NET_URL = "java.net.URL";
    private static final String JAVA_LANG_STRING = "java.lang.String";
    private static final String JAVA_LANG_STRINGBUFFER = "java.lang.StringBuffer";
    private static final String JAVA_LANG_CHARSEQUENCE = "java.lang.CharSequence";
    private static final String JAVA_UTIL_COLLECTION = "java.util.Collection";
    private static final String JAVA_UTIL_SCANNER = "java.util.Scanner";
    private static final String COMMONS_CODEC_CHARSETS = "org.apache.commons.codec.Charsets";
    private static final String COMMONS_CODEC_HEX = "org.apache.commons.codec.binary.Hex";
    private static final String COMMONS_CODEC_QUOTEDPRINTABLECODEC = "org.apache.commons.codec.net.QuotedPrintableCodec";
    private static final String COMMONS_IO = "org.apache.commons.io";
    private static final String COMMONS_IO_CHARSETS = "org.apache.commons.io.Charsets";
    private static final String COMMONS_IO_FILEUTILS = "org.apache.commons.io.FileUtils";
    private static final String COMMONS_IO_IOUTILS = "org.apache.commons.io.IOUtils";
    private static final String COMMONS_IO_CHARSEQUENCEINPUTSTREAM = "org.apache.commons.io.input.CharSequenceInputStream";
    private static final String COMMONS_IO_READERINPUTSTREAM = "org.apache.commons.io.input.ReaderInputStream";
    private static final String COMMONS_IO_REVERSEDLINESFILEREADER = "org.apache.commons.io.input.ReversedLinesFileReader";
    private static final String COMMONS_IO_LOCKABLEFILEWRITER = "org.apache.commons.io.output.LockableFileWriter";
    private static final String COMMONS_IO_WRITEROUTPUTSTREAM = "org.apache.commons.io.output.WriterOutputStream";
    private static final List<Charset> STANDARD_CHARSETS = Arrays.asList(StandardCharsets.ISO_8859_1, StandardCharsets.US_ASCII, StandardCharsets.UTF_16, StandardCharsets.UTF_16BE, StandardCharsets.UTF_16LE, StandardCharsets.UTF_8);
    private static final Map<String, String> ALIAS_TO_CONSTANT = StandardCharsetsConstantsCheck.createAliasToConstantNameMap();
    private static final int JAVA_10 = 10;

    private static Map<String, String> createAliasToConstantNameMap() {
        ImmutableMap.Builder constantNames = ImmutableMap.builder();
        for (Charset charset : STANDARD_CHARSETS) {
            String constantName = charset.name().replace("-", "_");
            constantNames.put((Object)charset.name(), (Object)constantName);
            for (String alias : charset.aliases()) {
                constantNames.put((Object)alias, (Object)constantName);
            }
        }
        return constantNames.build();
    }

    @Override
    public List<Tree.Kind> nodesToVisit() {
        return Arrays.asList(Tree.Kind.METHOD_INVOCATION, Tree.Kind.NEW_CLASS, Tree.Kind.IDENTIFIER);
    }

    @Override
    public void visitNode(Tree tree) {
        super.visitNode(tree);
        if (this.hasSemantic() && tree.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
            this.onMemberSelectExpressionFound((IdentifierTree)tree);
        }
    }

    private void onMemberSelectExpressionFound(IdentifierTree identifierTree) {
        Symbol symbol = identifierTree.symbol();
        if (symbol.isVariableSymbol() && symbol.owner().type().is("com.google.common.base.Charsets")) {
            String identifier = identifierTree.name();
            String aliasedIdentifier = identifier.replace("_", "-");
            if (STANDARD_CHARSETS.stream().anyMatch(c -> c.name().equals(aliasedIdentifier))) {
                this.reportIssue((Tree)identifierTree, "Replace \"com.google.common.base.Charsets." + identifier + "\" with \"StandardCharsets." + identifier + "\".");
            }
        }
    }

    @Override
    protected List<MethodMatcher> getMethodInvocationMatchers() {
        ArrayList<MethodMatcher> matchers = new ArrayList<MethodMatcher>(Arrays.asList(StandardCharsetsConstantsCheck.method(JAVA_NIO_CHARSET, "forName").parameters(new String[]{JAVA_LANG_STRING}), StandardCharsetsConstantsCheck.method(JAVA_LANG_STRING, "getBytes").parameters(new String[]{JAVA_LANG_STRING}), StandardCharsetsConstantsCheck.method(JAVA_LANG_STRING, "getBytes").parameters(new String[]{JAVA_NIO_CHARSET}), StandardCharsetsConstantsCheck.method(COMMONS_CODEC_CHARSETS, "toCharset").parameters(new String[]{JAVA_LANG_STRING}), StandardCharsetsConstantsCheck.method(COMMONS_IO_CHARSETS, "toCharset").parameters(new String[]{JAVA_LANG_STRING}), StandardCharsetsConstantsCheck.method(COMMONS_IO_FILEUTILS, "readFileToString").parameters(new String[]{JAVA_IO_FILE, JAVA_LANG_STRING}), StandardCharsetsConstantsCheck.method(COMMONS_IO_FILEUTILS, "readLines").parameters(new String[]{JAVA_IO_FILE, JAVA_LANG_STRING}), StandardCharsetsConstantsCheck.method(COMMONS_IO_FILEUTILS, WRITE).parameters(new String[]{JAVA_IO_FILE, JAVA_LANG_CHARSEQUENCE, JAVA_LANG_STRING}), StandardCharsetsConstantsCheck.method(COMMONS_IO_FILEUTILS, WRITE).parameters(new String[]{JAVA_IO_FILE, JAVA_LANG_CHARSEQUENCE, JAVA_LANG_STRING, BOOLEAN}), StandardCharsetsConstantsCheck.method(COMMONS_IO_FILEUTILS, "writeStringToFile").parameters(new String[]{JAVA_IO_FILE, JAVA_LANG_STRING, JAVA_LANG_STRING}), StandardCharsetsConstantsCheck.method(COMMONS_IO_FILEUTILS, "writeStringToFile").parameters(new String[]{JAVA_IO_FILE, JAVA_LANG_STRING, JAVA_LANG_STRING, BOOLEAN}), StandardCharsetsConstantsCheck.method(COMMONS_IO_IOUTILS, "copy").parameters(new String[]{JAVA_IO_INPUTSTREAM, JAVA_IO_WRITER, JAVA_LANG_STRING}), StandardCharsetsConstantsCheck.method(COMMONS_IO_IOUTILS, "copy").parameters(new String[]{JAVA_IO_READER, JAVA_IO_OUTPUTSTREAM, JAVA_LANG_STRING}), StandardCharsetsConstantsCheck.method(COMMONS_IO_IOUTILS, "lineIterator").parameters(new String[]{JAVA_IO_INPUTSTREAM, JAVA_LANG_STRING}), StandardCharsetsConstantsCheck.method(COMMONS_IO_IOUTILS, "readLines").parameters(new String[]{JAVA_IO_INPUTSTREAM, JAVA_LANG_STRING}), StandardCharsetsConstantsCheck.method(COMMONS_IO_IOUTILS, "toByteArray").parameters(new String[]{JAVA_IO_READER, JAVA_LANG_STRING}), StandardCharsetsConstantsCheck.method(COMMONS_IO_IOUTILS, "toCharArray").parameters(new String[]{JAVA_IO_INPUTSTREAM, JAVA_LANG_STRING}), StandardCharsetsConstantsCheck.method(COMMONS_IO_IOUTILS, "toInputStream").parameters(new String[]{JAVA_LANG_CHARSEQUENCE, JAVA_LANG_STRING}), StandardCharsetsConstantsCheck.method(COMMONS_IO_IOUTILS, "toInputStream").parameters(new String[]{JAVA_LANG_STRING, JAVA_LANG_STRING}), StandardCharsetsConstantsCheck.method(COMMONS_IO_IOUTILS, TO_STRING).parameters(new String[]{BYTE_ARRAY, JAVA_LANG_STRING}), StandardCharsetsConstantsCheck.method(COMMONS_IO_IOUTILS, TO_STRING).parameters(new String[]{JAVA_IO_INPUTSTREAM, JAVA_LANG_STRING}), StandardCharsetsConstantsCheck.method(COMMONS_IO_IOUTILS, TO_STRING).parameters(new String[]{JAVA_NET_URI, JAVA_LANG_STRING}), StandardCharsetsConstantsCheck.method(COMMONS_IO_IOUTILS, TO_STRING).parameters(new String[]{JAVA_NET_URL, JAVA_LANG_STRING}), StandardCharsetsConstantsCheck.method(COMMONS_IO_IOUTILS, WRITE).parameters(new String[]{BYTE_ARRAY, JAVA_IO_WRITER, JAVA_LANG_STRING}), StandardCharsetsConstantsCheck.method(COMMONS_IO_IOUTILS, WRITE).parameters(new String[]{"char[]", JAVA_IO_OUTPUTSTREAM, JAVA_LANG_STRING}), StandardCharsetsConstantsCheck.method(COMMONS_IO_IOUTILS, WRITE).parameters(new String[]{JAVA_LANG_CHARSEQUENCE, JAVA_IO_OUTPUTSTREAM, JAVA_LANG_STRING}), StandardCharsetsConstantsCheck.method(COMMONS_IO_IOUTILS, WRITE).parameters(new String[]{JAVA_LANG_STRING, JAVA_IO_OUTPUTSTREAM, JAVA_LANG_STRING}), StandardCharsetsConstantsCheck.method(COMMONS_IO_IOUTILS, WRITE).parameters(new String[]{JAVA_LANG_STRINGBUFFER, JAVA_IO_OUTPUTSTREAM, JAVA_LANG_STRING}), StandardCharsetsConstantsCheck.method(COMMONS_IO_IOUTILS, "writeLines").parameters(new String[]{JAVA_UTIL_COLLECTION, JAVA_LANG_STRING, JAVA_IO_OUTPUTSTREAM, JAVA_LANG_STRING}), StandardCharsetsConstantsCheck.constructor(JAVA_LANG_STRING).parameters(new String[]{BYTE_ARRAY, JAVA_LANG_STRING}), StandardCharsetsConstantsCheck.constructor(JAVA_LANG_STRING).parameters(new String[]{BYTE_ARRAY, INT, INT, JAVA_LANG_STRING}), StandardCharsetsConstantsCheck.constructor(JAVA_IO_INPUTSTREAMREADER).parameters(new String[]{JAVA_IO_INPUTSTREAM, JAVA_LANG_STRING}), StandardCharsetsConstantsCheck.constructor(JAVA_IO_OUTPUTSTREAMWRITER).parameters(new String[]{JAVA_IO_OUTPUTSTREAM, JAVA_LANG_STRING}), StandardCharsetsConstantsCheck.constructor(COMMONS_IO_CHARSEQUENCEINPUTSTREAM).parameters(new String[]{JAVA_LANG_CHARSEQUENCE, JAVA_LANG_STRING}), StandardCharsetsConstantsCheck.constructor(COMMONS_IO_CHARSEQUENCEINPUTSTREAM).parameters(new String[]{JAVA_LANG_CHARSEQUENCE, JAVA_LANG_STRING, INT}), StandardCharsetsConstantsCheck.constructor(COMMONS_IO_READERINPUTSTREAM).parameters(new String[]{JAVA_IO_READER, JAVA_LANG_STRING}), StandardCharsetsConstantsCheck.constructor(COMMONS_IO_READERINPUTSTREAM).parameters(new String[]{JAVA_IO_READER, JAVA_LANG_STRING, INT}), StandardCharsetsConstantsCheck.constructor(COMMONS_IO_REVERSEDLINESFILEREADER).parameters(new String[]{JAVA_IO_FILE, INT, JAVA_LANG_STRING}), StandardCharsetsConstantsCheck.constructor(COMMONS_IO_LOCKABLEFILEWRITER).parameters(new String[]{JAVA_IO_FILE, JAVA_LANG_STRING}), StandardCharsetsConstantsCheck.constructor(COMMONS_IO_LOCKABLEFILEWRITER).parameters(new String[]{JAVA_IO_FILE, JAVA_LANG_STRING, BOOLEAN, JAVA_LANG_STRING}), StandardCharsetsConstantsCheck.constructor(COMMONS_IO_WRITEROUTPUTSTREAM).parameters(new String[]{JAVA_IO_WRITER, JAVA_LANG_STRING}), StandardCharsetsConstantsCheck.constructor(COMMONS_IO_WRITEROUTPUTSTREAM).parameters(new String[]{JAVA_IO_WRITER, JAVA_LANG_STRING, INT, BOOLEAN}), StandardCharsetsConstantsCheck.constructor(COMMONS_CODEC_HEX).parameters(new String[]{JAVA_LANG_STRING}), StandardCharsetsConstantsCheck.constructor(COMMONS_CODEC_QUOTEDPRINTABLECODEC).parameters(new String[]{JAVA_LANG_STRING})));
        if (this.context.getJavaVersion().asInt() >= 10) {
            matchers.add(StandardCharsetsConstantsCheck.method(JAVA_IO_BYTEARRAYOUTPUTSTREAM, TO_STRING).parameters(new String[]{JAVA_LANG_STRING}));
            matchers.add(StandardCharsetsConstantsCheck.constructor(JAVA_UTIL_SCANNER).parameters(new String[]{JAVA_IO_INPUTSTREAM, JAVA_LANG_STRING}));
            matchers.add(StandardCharsetsConstantsCheck.constructor(JAVA_UTIL_SCANNER).parameters(new String[]{JAVA_IO_FILE, JAVA_LANG_STRING}));
            matchers.add(StandardCharsetsConstantsCheck.constructor(JAVA_UTIL_SCANNER).parameters(new String[]{JAVA_NIO_FILE_PATH, JAVA_LANG_STRING}));
            matchers.add(StandardCharsetsConstantsCheck.constructor(JAVA_UTIL_SCANNER).parameters(new String[]{JAVA_NIO_CHANNELS_READABLEBYTECHANNEL, JAVA_LANG_STRING}));
        }
        return matchers;
    }

    private static MethodMatcher method(String type, String name) {
        return MethodMatcher.create().typeDefinition(type).name(name);
    }

    private static MethodMatcher constructor(String type) {
        return MethodMatcher.create().typeDefinition(type).name("<init>");
    }

    @Override
    protected void onMethodInvocationFound(MethodInvocationTree mit) {
        this.checkCall((ExpressionTree)mit, mit.symbol(), mit.arguments());
    }

    @Override
    protected void onConstructorFound(NewClassTree newClassTree) {
        this.checkCall((ExpressionTree)newClassTree, newClassTree.constructorSymbol(), newClassTree.arguments());
    }

    private void checkCall(ExpressionTree callExpression, Symbol symbol, Arguments arguments) {
        StandardCharsetsConstantsCheck.getCharsetNameArgument(symbol, arguments).ifPresent(charsetNameArgument -> StandardCharsetsConstantsCheck.getConstantName(charsetNameArgument).ifPresent(constantName -> {
            String methodRef;
            switch (methodRef = StandardCharsetsConstantsCheck.getMethodRef(symbol)) {
                case "Charset.forName": 
                case "Charsets.toCharset": {
                    this.reportIssue((Tree)callExpression, String.format("Replace %s() call with StandardCharsets.%s", methodRef, constantName));
                    break;
                }
                case "IOUtils.toString": {
                    if (arguments.size() == 2 && ((ExpressionTree)arguments.get(0)).symbolType().is(BYTE_ARRAY)) {
                        this.reportIssue((Tree)callExpression, "Replace IOUtils.toString() call with new String(..., StandardCharsets." + constantName + ");");
                        break;
                    }
                    this.reportDefaultIssue((ExpressionTree)charsetNameArgument, (String)constantName);
                    break;
                }
                default: {
                    this.reportDefaultIssue((ExpressionTree)charsetNameArgument, (String)constantName);
                }
            }
        }));
    }

    private void reportDefaultIssue(ExpressionTree charsetNameArgument, String constantName) {
        this.reportIssue((Tree)charsetNameArgument, "Replace charset name argument with StandardCharsets." + constantName);
    }

    private static Optional<ExpressionTree> getCharsetNameArgument(Symbol symbol, Arguments arguments) {
        List stringArguments = arguments.stream().filter(argument -> argument.symbolType().is(JAVA_LANG_STRING)).collect(Collectors.toList());
        if (stringArguments.isEmpty()) {
            return Optional.empty();
        }
        if (stringArguments.size() == 1) {
            return Optional.of((ExpressionTree)stringArguments.get(0));
        }
        switch (StandardCharsetsConstantsCheck.getMethodRef(symbol)) {
            case "FileUtils.writeStringToFile": 
            case "IOUtils.toInputStream": 
            case "IOUtils.write": 
            case "IOUtils.writeLines": {
                return Optional.of((ExpressionTree)Iterables.getLast(stringArguments));
            }
            case "LockableFileWriter.<init>": {
                return Optional.of((ExpressionTree)stringArguments.get(0));
            }
        }
        return Optional.empty();
    }

    private static String getMethodRef(Symbol symbol) {
        return symbol.enclosingClass().name() + "." + symbol.name();
    }

    private static Optional<String> getConstantName(ExpressionTree argument) {
        return argument.asConstant(String.class).map(ALIAS_TO_CONSTANT::get).flatMap(Optional::ofNullable);
    }

    public boolean isCompatibleWithJavaVersion(JavaVersion version) {
        return version.isJava7Compatible();
    }
}

