/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Arrays;
import java.util.List;
import java.util.function.BiPredicate;
import javax.annotation.CheckForNull;
import org.sonar.check.Rule;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.java.matcher.MethodMatcher;
import org.sonar.plugins.java.api.tree.Arguments;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S3039")
public class StringCallsBeyondBoundsCheck
extends AbstractMethodDetection {
    private static final String STRING = "java.lang.String";
    private static final MethodMatcher STRING_LENGTH = MethodMatcher.create().typeDefinition("java.lang.String").name("length").withoutParameter();

    @Override
    protected List<MethodMatcher> getMethodInvocationMatchers() {
        return Arrays.asList(MethodMatcher.create().typeDefinition(STRING).name("charAt").addParameter("int"), MethodMatcher.create().typeDefinition(STRING).name("codePointAt").addParameter("int"), MethodMatcher.create().typeDefinition(STRING).name("codePointBefore").addParameter("int"), MethodMatcher.create().typeDefinition(STRING).name("codePointCount").addParameter("int").addParameter("int"), MethodMatcher.create().typeDefinition(STRING).name("getChars").addParameter("int").addParameter("int").addParameter("char[]").addParameter("int"), MethodMatcher.create().typeDefinition(STRING).name("offsetByCodePoints").addParameter("int").addParameter("int"), MethodMatcher.create().typeDefinition(STRING).name("substring").addParameter("int"), MethodMatcher.create().typeDefinition(STRING).name("substring").addParameter("int").addParameter("int"), MethodMatcher.create().typeDefinition(STRING).name("subSequence").addParameter("int").addParameter("int"));
    }

    @Override
    protected void onMethodInvocationFound(MethodInvocationTree invocation) {
        boolean issue;
        String method;
        switch (method = invocation.symbol().name()) {
            case "charAt": 
            case "codePointAt": {
                issue = StringCallsBeyondBoundsCheck.checkCodePointAt(invocation);
                break;
            }
            case "codePointBefore": {
                issue = StringCallsBeyondBoundsCheck.checkCodePointBefore(invocation);
                break;
            }
            case "getChars": {
                issue = StringCallsBeyondBoundsCheck.checkGetChars(invocation);
                break;
            }
            case "offsetByCodePoints": {
                issue = StringCallsBeyondBoundsCheck.checkOffsetByCodePoints(invocation);
                break;
            }
            case "codePointCount": 
            case "subSequence": {
                issue = StringCallsBeyondBoundsCheck.checkSubsequence(invocation);
                break;
            }
            case "substring": {
                issue = StringCallsBeyondBoundsCheck.checkSubstring(invocation);
                break;
            }
            default: {
                issue = false;
            }
        }
        if (issue) {
            this.reportIssue((Tree)invocation, String.format("Refactor this \"%s\" call; it will result in an \"StringIndexOutOfBounds\" exception at runtime.", invocation.symbol().name()));
        }
    }

    private static boolean check(MethodInvocationTree invocation, BiPredicate<ExpressionTree, Arguments> condition) {
        if (invocation.methodSelect().is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
            ExpressionTree string = ((MemberSelectExpressionTree)invocation.methodSelect()).expression();
            Arguments arguments = invocation.arguments();
            return condition.test(string, arguments);
        }
        return false;
    }

    private static boolean checkCodePointAt(MethodInvocationTree tree) {
        return StringCallsBeyondBoundsCheck.check(tree, (str, args) -> {
            Integer index = StringCallsBeyondBoundsCheck.constant((ExpressionTree)args.get(0));
            if (index != null && index < 0) {
                return true;
            }
            Integer strlen = StringCallsBeyondBoundsCheck.length(str);
            if (index != null && strlen != null && index >= strlen) {
                return true;
            }
            return StringCallsBeyondBoundsCheck.isStringLength(str, (ExpressionTree)args.get(0));
        });
    }

    private static boolean checkCodePointBefore(MethodInvocationTree tree) {
        return StringCallsBeyondBoundsCheck.check(tree, (str, args) -> {
            Integer index = StringCallsBeyondBoundsCheck.constant((ExpressionTree)args.get(0));
            if (index != null && index < 1) {
                return true;
            }
            Integer strlen = StringCallsBeyondBoundsCheck.length(str);
            return index != null && strlen != null && index > strlen;
        });
    }

    private static boolean checkGetChars(MethodInvocationTree tree) {
        return StringCallsBeyondBoundsCheck.check(tree, (str, args) -> {
            if (StringCallsBeyondBoundsCheck.isStringLength(str, (ExpressionTree)args.get(0))) {
                return true;
            }
            Integer srcBegin = StringCallsBeyondBoundsCheck.constant((ExpressionTree)args.get(0));
            if (srcBegin != null && srcBegin < 0) {
                return true;
            }
            Integer srcEnd = StringCallsBeyondBoundsCheck.constant((ExpressionTree)args.get(1));
            if (srcBegin != null && srcEnd != null && srcBegin > srcEnd) {
                return true;
            }
            Integer strlen = StringCallsBeyondBoundsCheck.length(str);
            if (srcEnd != null && strlen != null && srcEnd > strlen) {
                return true;
            }
            Integer dstBegin = StringCallsBeyondBoundsCheck.constant((ExpressionTree)args.get(3));
            return dstBegin != null && dstBegin < 0;
        });
    }

    private static boolean checkOffsetByCodePoints(MethodInvocationTree tree) {
        return StringCallsBeyondBoundsCheck.check(tree, (str, args) -> {
            if (StringCallsBeyondBoundsCheck.isStringLength(str, (ExpressionTree)args.get(0))) {
                return true;
            }
            Integer index = StringCallsBeyondBoundsCheck.constant((ExpressionTree)args.get(0));
            if (index != null && index < 0) {
                return true;
            }
            Integer strlen = StringCallsBeyondBoundsCheck.length(str);
            return index != null && strlen != null && index > strlen;
        });
    }

    private static boolean checkSubstring(MethodInvocationTree tree) {
        int arity = tree.arguments().size();
        if (arity == 2) {
            return StringCallsBeyondBoundsCheck.checkSubsequence(tree);
        }
        return StringCallsBeyondBoundsCheck.check(tree, (str, args) -> {
            if (StringCallsBeyondBoundsCheck.isStringLength(str, (ExpressionTree)args.get(0))) {
                return true;
            }
            Integer index = StringCallsBeyondBoundsCheck.constant((ExpressionTree)args.get(0));
            if (index != null && index < 0) {
                return true;
            }
            Integer strlen = StringCallsBeyondBoundsCheck.length(str);
            return index != null && strlen != null && index > strlen;
        });
    }

    private static boolean checkSubsequence(MethodInvocationTree tree) {
        return StringCallsBeyondBoundsCheck.check(tree, (str, args) -> {
            if (StringCallsBeyondBoundsCheck.isStringLength(str, (ExpressionTree)args.get(0))) {
                return true;
            }
            Integer beginIndex = StringCallsBeyondBoundsCheck.constant((ExpressionTree)args.get(0));
            if (beginIndex != null && beginIndex < 0) {
                return true;
            }
            Integer endIndex = StringCallsBeyondBoundsCheck.constant((ExpressionTree)args.get(1));
            if (beginIndex != null && endIndex != null && beginIndex > endIndex) {
                return true;
            }
            Integer strlen = StringCallsBeyondBoundsCheck.length(str);
            return endIndex != null && strlen != null && endIndex > strlen;
        });
    }

    private static boolean isStringLength(ExpressionTree str, ExpressionTree tree) {
        MethodInvocationTree invocation;
        if (str.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER}) && tree.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION}) && STRING_LENGTH.matches(invocation = (MethodInvocationTree)tree) && invocation.methodSelect().is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
            ExpressionTree expr = ((MemberSelectExpressionTree)invocation.methodSelect()).expression();
            return expr.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER}) && ((IdentifierTree)str).symbol().equals(((IdentifierTree)expr).symbol());
        }
        return false;
    }

    @CheckForNull
    private static Integer constant(ExpressionTree tree) {
        return tree.asConstant(Integer.class).orElse(null);
    }

    @CheckForNull
    private static Integer length(ExpressionTree tree) {
        return tree.asConstant(String.class).map(String::length).orElse(null);
    }
}

