/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Arrays;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.java.matcher.MethodMatcher;
import org.sonar.java.matcher.TypeCriteria;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S4635")
public class StringOffsetMethodsCheck
extends AbstractMethodDetection {
    private static final TypeCriteria JAVA_LANG_STRING = TypeCriteria.is((String)"java.lang.String");
    private static final TypeCriteria INT = TypeCriteria.is((String)"int");
    private static final MethodMatcher SUBSTRING = MethodMatcher.create().typeDefinition(JAVA_LANG_STRING).name("substring").parameters(new TypeCriteria[]{INT});

    @Override
    protected List<MethodMatcher> getMethodInvocationMatchers() {
        return Arrays.asList(MethodMatcher.create().typeDefinition(JAVA_LANG_STRING).name("indexOf").parameters(new TypeCriteria[]{JAVA_LANG_STRING}), MethodMatcher.create().typeDefinition(JAVA_LANG_STRING).name("indexOf").parameters(new TypeCriteria[]{INT}), MethodMatcher.create().typeDefinition(JAVA_LANG_STRING).name("lastIndexOf").parameters(new TypeCriteria[]{JAVA_LANG_STRING}), MethodMatcher.create().typeDefinition(JAVA_LANG_STRING).name("lastIndexOf").parameters(new TypeCriteria[]{INT}), MethodMatcher.create().typeDefinition(JAVA_LANG_STRING).name("startsWith").parameters(new TypeCriteria[]{JAVA_LANG_STRING}));
    }

    @Override
    protected void onMethodInvocationFound(MethodInvocationTree mit) {
        ExpressionTree expression;
        ExpressionTree methodSelect = mit.methodSelect();
        if (methodSelect.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT}) && (expression = ((MemberSelectExpressionTree)methodSelect).expression()).is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION}) && SUBSTRING.matches(((MethodInvocationTree)expression).symbol())) {
            this.reportIssue((Tree)ExpressionUtils.methodName((MethodInvocationTree)((MethodInvocationTree)expression)), (Tree)mit, String.format("Replace \"%s\" with the overload that accepts an offset parameter.", mit.symbol().name()));
        }
    }
}

