/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.security;

import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.sonar.check.Rule;
import org.sonar.java.checks.helpers.ExpressionsHelper;
import org.sonar.java.checks.helpers.JavaPropertiesHelper;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.java.matcher.MethodMatcher;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S5542")
public class EncryptionAlgorithmCheck
extends AbstractMethodDetection {
    private static final Pattern ALGORITHM_PATTERN = Pattern.compile("(.+)/(.+)/(.+)");

    @Override
    protected List<MethodMatcher> getMethodInvocationMatchers() {
        return Collections.singletonList(MethodMatcher.create().typeDefinition("javax.crypto.Cipher").name("getInstance").withAnyParameters());
    }

    @Override
    protected void onMethodInvocationFound(MethodInvocationTree mit) {
        if (mit.arguments().isEmpty()) {
            return;
        }
        ExpressionTree firstArgument = (ExpressionTree)mit.arguments().get(0);
        ExpressionTree defaultPropertyValue = JavaPropertiesHelper.retrievedPropertyDefaultValue(firstArgument);
        ExpressionTree algorithmTree = defaultPropertyValue == null ? firstArgument : defaultPropertyValue;
        String algorithmName = ExpressionsHelper.getConstantValueAsString(algorithmTree).value();
        if (algorithmName != null && EncryptionAlgorithmCheck.isInsecureAlgorithm(algorithmName)) {
            this.reportIssue((Tree)firstArgument, "Use secure mode and padding scheme.");
        }
    }

    private static boolean isInsecureAlgorithm(String algorithmName) {
        Matcher matcher = ALGORITHM_PATTERN.matcher(algorithmName);
        if (matcher.matches()) {
            String algorithm = matcher.group(1);
            String mode = matcher.group(2);
            String padding = matcher.group(3);
            if ("ECB".equals(mode)) {
                return true;
            }
            if ("CBC".equals(mode)) {
                return "PKCS5Padding".equals(padding) || "PKCS7Padding".equals(padding);
            }
            if ("RSA".equals(algorithm)) {
                return !"OAEPWITHSHA-256ANDMGF1PADDING".equals(padding) && !"OAEPWithSHA-1AndMGF1Padding".equals(padding);
            }
            return false;
        }
        return true;
    }
}

