/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.security;

import java.util.Arrays;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.java.matcher.MethodMatcher;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TypeTree;

@Rule(key="S4818")
public class SocketUsageCheck
extends AbstractMethodDetection {
    private static final String MESSAGE = "Make sure that sockets are used safely here.";
    private static final String JAVAX_NET_SOCKET_FACTORY = "javax.net.SocketFactory";
    private static final String INIT = "<init>";
    private static final String OPEN_METHOD = "open";

    @Override
    public List<Tree.Kind> nodesToVisit() {
        return Arrays.asList(Tree.Kind.METHOD_INVOCATION, Tree.Kind.NEW_CLASS, Tree.Kind.METHOD_REFERENCE, Tree.Kind.CLASS);
    }

    @Override
    protected List<MethodMatcher> getMethodInvocationMatchers() {
        return Arrays.asList(MethodMatcher.create().typeDefinition("java.net.Socket").name(INIT).withAnyParameters(), MethodMatcher.create().typeDefinition("java.net.ServerSocket").name(INIT).withAnyParameters(), MethodMatcher.create().typeDefinition(JAVAX_NET_SOCKET_FACTORY).name(INIT).withAnyParameters(), MethodMatcher.create().typeDefinition(JAVAX_NET_SOCKET_FACTORY).name("createSocket").withAnyParameters(), MethodMatcher.create().typeDefinition("java.nio.channels.AsynchronousServerSocketChannel").name(OPEN_METHOD).withAnyParameters(), MethodMatcher.create().typeDefinition("java.nio.channels.AsynchronousSocketChannel").name(OPEN_METHOD).withAnyParameters(), MethodMatcher.create().typeDefinition("java.nio.channels.SocketChannel").name(OPEN_METHOD).withAnyParameters(), MethodMatcher.create().typeDefinition("java.nio.channels.ServerSocketChannel").name(OPEN_METHOD).withAnyParameters(), MethodMatcher.create().typeDefinition("io.netty.channel.ChannelInitializer").name(INIT).withAnyParameters());
    }

    @Override
    public void visitNode(Tree tree) {
        if (!this.hasSemantic()) {
            return;
        }
        if (tree.is(new Tree.Kind[]{Tree.Kind.CLASS})) {
            this.checkExtensions((ClassTree)tree);
        } else {
            super.visitNode(tree);
        }
    }

    private void checkExtensions(ClassTree tree) {
        TypeTree superClass;
        if ((tree.symbol().type().isSubtypeOf(JAVAX_NET_SOCKET_FACTORY) || tree.symbol().type().isSubtypeOf("io.netty.channel.ChannelInitializer")) && (superClass = tree.superClass()) != null) {
            this.reportIssue((Tree)superClass, MESSAGE);
        }
    }

    @Override
    protected void onMethodInvocationFound(MethodInvocationTree mit) {
        this.reportIssue((Tree)mit, MESSAGE);
    }

    @Override
    protected void onConstructorFound(NewClassTree newClassTree) {
        this.reportIssue((Tree)newClassTree, MESSAGE);
    }
}

