/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.security;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import org.sonar.check.Rule;
import org.sonar.java.checks.helpers.ExpressionsHelper;
import org.sonar.java.matcher.MethodMatcher;
import org.sonar.java.matcher.TypeCriteria;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.tree.Arguments;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;

@Rule(key="S2755")
public class XmlExternalEntityProcessingCheck
extends IssuableSubscriptionVisitor {
    private static final String XML_INPUT_FACTORY_CLASS_NAME = "javax.xml.stream.XMLInputFactory";
    private static final String SAX_PARSER_FACTORY_CLASS_NAME = "javax.xml.parsers.SAXParserFactory";
    private static final String XML_READER_FACTORY_CLASS_NAME = "org.xml.sax.helpers.XMLReaderFactory";
    private static final String XML_READER_CLASS_NAME = "org.xml.sax.XMLReader";
    private static final String DOCUMENT_BUILDER_FACTORY_CLASS_NAME = "javax.xml.parsers.DocumentBuilderFactory";
    private static final String VALIDATOR_CLASS_NAME = "javax.xml.validation.Validator";
    private static final String SCHEMA_CLASS_NAME = "javax.xml.validation.Schema";
    private static final MethodMatcher CREATE_XML_READER_MATCHER = MethodMatcher.create().typeDefinition("org.xml.sax.helpers.XMLReaderFactory").name("createXMLReader").withAnyParameters();
    private static final MethodMatcher CREATE_VALIDATOR = MethodMatcher.create().typeDefinition("javax.xml.validation.Schema").name("newValidator").withAnyParameters();
    private static final String JAVA_LANG_STRING = "java.lang.String";
    private final List<XxeCheck> xxeChecks = Arrays.asList(new XxeCheck(XmlExternalEntityProcessingCheck.newInstanceMethod("javax.xml.stream.XMLInputFactory"), new XMLInputFactorySecuringPredicate()), new XxeCheck(MethodMatcher.create().typeDefinition("javax.xml.stream.XMLInputFactory").name("newFactory").withAnyParameters(), new XMLInputFactorySecuringPredicate()), new XxeCheck(XmlExternalEntityProcessingCheck.newInstanceMethod("javax.xml.parsers.SAXParserFactory"), new SecureProcessingFeaturePredicate("javax.xml.parsers.SAXParserFactory")), new XxeCheck(XmlExternalEntityProcessingCheck.newInstanceMethod("javax.xml.parsers.DocumentBuilderFactory"), new SecureProcessingFeaturePredicate("javax.xml.parsers.DocumentBuilderFactory")), new XxeCheck(CREATE_XML_READER_MATCHER, new SecureProcessingFeaturePredicate("org.xml.sax.XMLReader")), new XxeCheck(CREATE_VALIDATOR, new AccessExternalDTDOrSchemaPredicate("javax.xml.validation.Validator")));

    private static MethodMatcher newInstanceMethod(String className) {
        return MethodMatcher.create().typeDefinition(className).name("newInstance").withAnyParameters();
    }

    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.METHOD_INVOCATION);
    }

    public void visitNode(Tree tree) {
        this.xxeChecks.forEach(check -> ((XxeCheck)check).checkMethodInvocation((MethodInvocationTree)tree));
    }

    private static class AccessExternalDTDOrSchemaPredicate
    implements Predicate<MethodInvocationTree> {
        private static final String ACCESS_EXTERNAL_DTD_PROPERTY = "http://javax.xml.XMLConstants/property/accessExternalDTD";
        private static final String ACCESS_EXTERNAL_SCHEMA_PROPERTY = "http://javax.xml.XMLConstants/property/accessExternalSchema";
        private final MethodMatcher methodMatcher;
        private boolean externalDTDDisabled = false;
        private boolean externalSchemaDisabled = false;

        private AccessExternalDTDOrSchemaPredicate(String className) {
            this.methodMatcher = AccessExternalDTDOrSchemaPredicate.setPropertyMethodMatcher(className);
        }

        @Override
        public boolean test(MethodInvocationTree methodInvocation) {
            if (this.methodMatcher.matches(methodInvocation)) {
                Arguments arguments = methodInvocation.arguments();
                String propertyName = ExpressionsHelper.getConstantValueAsString((ExpressionTree)arguments.get(0)).value();
                String propertyValue = ExpressionsHelper.getConstantValueAsString((ExpressionTree)arguments.get(1)).value();
                if ("".equals(propertyValue) && ACCESS_EXTERNAL_DTD_PROPERTY.equals(propertyName)) {
                    this.externalDTDDisabled = true;
                }
                if ("".equals(propertyValue) && ACCESS_EXTERNAL_SCHEMA_PROPERTY.equals(propertyName)) {
                    this.externalSchemaDisabled = true;
                }
                return this.externalDTDDisabled && this.externalSchemaDisabled;
            }
            return false;
        }

        private static MethodMatcher setPropertyMethodMatcher(String className) {
            return MethodMatcher.create().typeDefinition(TypeCriteria.subtypeOf((String)className)).name("setProperty").parameters(new String[]{XmlExternalEntityProcessingCheck.JAVA_LANG_STRING, "java.lang.Object"});
        }
    }

    private static class SecureProcessingFeaturePredicate
    implements Predicate<MethodInvocationTree> {
        private static final String FEATURE_SECURE_PROCESSING_PROPERTY = "http://javax.xml.XMLConstants/feature/secure-processing";
        private static final String FEATURE_DISALLOW_DOCTYPE_DECL = "http://apache.org/xml/features/disallow-doctype-decl";
        private final MethodMatcher methodMatcher;

        private SecureProcessingFeaturePredicate(String className) {
            this.methodMatcher = SecureProcessingFeaturePredicate.setFeatureMethodMatcher(className);
        }

        @Override
        public boolean test(MethodInvocationTree methodInvocation) {
            if (this.methodMatcher.matches(methodInvocation)) {
                Arguments arguments = methodInvocation.arguments();
                String featureName = ExpressionsHelper.getConstantValueAsString((ExpressionTree)arguments.get(0)).value();
                return Boolean.TRUE.equals(ExpressionsHelper.getConstantValueAsBoolean((ExpressionTree)arguments.get(1)).value()) && (FEATURE_SECURE_PROCESSING_PROPERTY.equals(featureName) || FEATURE_DISALLOW_DOCTYPE_DECL.equals(featureName));
            }
            return false;
        }

        private static MethodMatcher setFeatureMethodMatcher(String className) {
            return MethodMatcher.create().typeDefinition(TypeCriteria.subtypeOf((String)className)).name("setFeature").parameters(new String[]{XmlExternalEntityProcessingCheck.JAVA_LANG_STRING, "boolean"});
        }
    }

    private static class XMLInputFactorySecuringPredicate
    implements Predicate<MethodInvocationTree> {
        private static final String IS_SUPPORTING_EXTERNAL_ENTITIES_PROPERTY = "javax.xml.stream.isSupportingExternalEntities";
        private static final String SUPPORT_DTD_PROPERTY = "javax.xml.stream.supportDTD";
        private static final MethodMatcher SET_PROPERTY = MethodMatcher.create().typeDefinition(TypeCriteria.subtypeOf((String)"javax.xml.stream.XMLInputFactory")).name("setProperty").parameters(new String[]{"java.lang.String", "java.lang.Object"});

        private XMLInputFactorySecuringPredicate() {
        }

        @Override
        public boolean test(MethodInvocationTree methodInvocation) {
            String propertyName;
            Arguments arguments = methodInvocation.arguments();
            if (SET_PROPERTY.matches(methodInvocation) && (IS_SUPPORTING_EXTERNAL_ENTITIES_PROPERTY.equals(propertyName = ExpressionsHelper.getConstantValueAsString((ExpressionTree)arguments.get(0)).value()) || SUPPORT_DTD_PROPERTY.equals(propertyName))) {
                ExpressionTree propertyValue = (ExpressionTree)arguments.get(1);
                return Boolean.FALSE.equals(ExpressionsHelper.getConstantValueAsBoolean(propertyValue).value()) || "false".equalsIgnoreCase(ExpressionsHelper.getConstantValueAsString(propertyValue).value());
            }
            return false;
        }
    }

    private static class MethodVisitor
    extends BaseTreeVisitor {
        private final Predicate<MethodInvocationTree> securingInvocationPredicate;
        private boolean isExternalEntityProcessingDisabled = false;

        private MethodVisitor(Predicate<MethodInvocationTree> securingInvocationPredicate) {
            this.securingInvocationPredicate = securingInvocationPredicate;
        }

        public void visitMethodInvocation(MethodInvocationTree methodInvocation) {
            if (this.securingInvocationPredicate.test(methodInvocation)) {
                this.isExternalEntityProcessingDisabled = true;
            }
            super.visitMethodInvocation(methodInvocation);
        }
    }

    private class XxeCheck {
        private final MethodMatcher triggeringInvocationMatcher;
        private final Predicate<MethodInvocationTree> securingInvocationPredicate;

        private XxeCheck(MethodMatcher triggeringInvocationMatcher, Predicate<MethodInvocationTree> securingInvocationPredicate) {
            this.triggeringInvocationMatcher = triggeringInvocationMatcher;
            this.securingInvocationPredicate = securingInvocationPredicate;
        }

        private void checkMethodInvocation(MethodInvocationTree methodInvocation) {
            MethodTree enclosingMethod;
            if (this.triggeringInvocationMatcher.matches(methodInvocation) && (enclosingMethod = ExpressionUtils.getEnclosingMethod((ExpressionTree)methodInvocation)) != null) {
                if (this.securingInvocationPredicate instanceof AccessExternalDTDOrSchemaPredicate) {
                    ((AccessExternalDTDOrSchemaPredicate)this.securingInvocationPredicate).externalDTDDisabled = false;
                    ((AccessExternalDTDOrSchemaPredicate)this.securingInvocationPredicate).externalSchemaDisabled = false;
                }
                MethodVisitor methodVisitor = new MethodVisitor(this.securingInvocationPredicate);
                enclosingMethod.accept((TreeVisitor)methodVisitor);
                if (!methodVisitor.isExternalEntityProcessingDisabled) {
                    XmlExternalEntityProcessingCheck.this.reportIssue((Tree)methodInvocation.methodSelect(), "Disable XML external entity (XXE) processing.");
                }
            }
        }
    }
}

