/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.BinaryExpressionTree;
import org.sonar.plugins.java.api.tree.ConditionalExpressionTree;
import org.sonar.plugins.java.api.tree.LiteralTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.UnaryExpressionTree;

@Rule(key="S1125")
public class BooleanLiteralCheck
extends IssuableSubscriptionVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return Arrays.asList(Tree.Kind.EQUAL_TO, Tree.Kind.NOT_EQUAL_TO, Tree.Kind.CONDITIONAL_AND, Tree.Kind.CONDITIONAL_OR, Tree.Kind.LOGICAL_COMPLEMENT, Tree.Kind.CONDITIONAL_EXPRESSION);
    }

    public void visitNode(Tree tree) {
        ConditionalExpressionTree expression;
        List<LiteralTree> literalList;
        if (tree.is(new Tree.Kind[]{Tree.Kind.LOGICAL_COMPLEMENT})) {
            literalList = BooleanLiteralCheck.getBooleanLiterals(new Tree[]{((UnaryExpressionTree)tree).expression()});
        } else if (tree.is(new Tree.Kind[]{Tree.Kind.CONDITIONAL_EXPRESSION})) {
            expression = (ConditionalExpressionTree)tree;
            literalList = BooleanLiteralCheck.getBooleanLiterals(new Tree[]{expression.trueExpression(), expression.falseExpression()});
        } else {
            expression = (BinaryExpressionTree)tree;
            literalList = BooleanLiteralCheck.getBooleanLiterals(new Tree[]{expression.leftOperand(), expression.rightOperand()});
        }
        int nLiterals = literalList.size();
        if (nLiterals > 0) {
            this.reportIssue((Tree)literalList.get(0), String.format("Remove the unnecessary boolean literal%s.", nLiterals > 1 ? "s" : ""), literalList.stream().skip(1L).map(lit -> new JavaFileScannerContext.Location("", (Tree)lit)).collect(Collectors.toList()), null);
        }
    }

    private static List<LiteralTree> getBooleanLiterals(Tree ... trees) {
        ArrayList<LiteralTree> booleanLiterals = new ArrayList<LiteralTree>();
        for (Tree t : trees) {
            if (t.is(new Tree.Kind[]{Tree.Kind.NULL_LITERAL})) {
                return Collections.emptyList();
            }
            if (!t.is(new Tree.Kind[]{Tree.Kind.BOOLEAN_LITERAL})) continue;
            booleanLiterals.add((LiteralTree)t);
        }
        return booleanLiterals;
    }
}

